require 'RMagick'
include Magick

#Wymiary dostosowane do rysunku o wielkoci 3072x2048.

unless ARGV[0] and File.exists?(ARGV[0])
    puts "\n\n\nMusisz poda nazw pliku: watermark.rb <nazwapliku>\n\n\n"	
  exit
end

img = Image.read(ARGV[0]).first
new_img = "wm_#{ARGV[0]}"

if File.exists?(new_img)
  puts "Zdjcie ju istnieje - nie mona utworzy pliku."
  exit
end

watermark = Image.new(600, 50)

watermark_text = Draw.new
watermark_text.annotate(watermark, 0,0,0,0, "Pics by No Starch") do
  watermark_text.gravity = CenterGravity
  self.pointsize = 50
  self.font_family = "Arial"			#Jeli masz wymyln czcionk, moesz jej uy w tym miejscu.
  self.font_weight = BoldWeight
  self.stroke = "none"
end

watermark.rotate!(45)
watermark = watermark.shade(true, 310, 30)
img.composite!(watermark, SouthWestGravity, HardLightCompositeOp)		#Oznaczenie w lewym dolnym rogu.
watermark.rotate!(-90)
img.composite!(watermark, NorthWestGravity, HardLightCompositeOp)		#Oznaczenie w lewym grnym rogu.
watermark.rotate!(90)
img.composite!(watermark, NorthEastGravity, HardLightCompositeOp)		#Oznaczenie w prawym grnym rogu.
watermark.rotate!(-90)
img.composite!(watermark, SouthEastGravity, HardLightCompositeOp)		#Oznaczenie w prawym dolnym rogu.

puts "Zapisywanie pliku #{new_img}"
img.write(new_img)
