#!/usr/bin/ruby

unless ARGV[0]
    puts "Sposb uycia: ruby fixFilename.rb <nazwapliku.roz>"
    puts "Przykad: ruby fixFilename.rb \'How to (make) 20% more on $500.pdf\'"
  exit
end

old_filename = ARGV[0]

unless File.exist?(old_filename)
    puts "Plik #{old_filename} nie istnieje. Sprbuj ponownie."
  exit
end

name = File.basename(old_filename, ".*")
ext = File.extname(old_filename)

#Tablica na kopotliwe znaki nazw plikw (w razie potrzeby zmie jej zawarto).
replacements = {  /;/ => "-",
  /\s/ => "_",
  /\'\`/ => "=",
  /\&/ => "_and_",
  /\$/ => "dollar_",
  /%/ => "_percent",
  /[\(\)\[\]<>]/ => ""
}  

#Przejcie przez wszystkie pliki.
replacements.each do |orig, fix|
  name.gsub!(orig,fix)
end

#Zmienianie zych nazw plikw na poprawne.
File.rename(old_filename, name + ext)

#No tak - trzeba jeszcze poinformowa uytkownika, co jest grane.
puts "#{old_filename} ---> #{name + ext}"
