# == Opis programu
# 
#  web_scraper: Wydobywanie okrelonych informacji ze stron WWW
# 
# 
# == Sposb uycia
# 
# web_scraper [OPCJE] ... URL
# 
# -h, --help
#   Wywietla pomoc
# 
# --links , -l
#   Wydobywa wszystkie odnoniki ze strony WWW
# 
# --images, -i
#   Wydobywa wszystkie rysunki ze strony WWW
# 
# --page, -p
#   Wydobywa cay kod HTML ze strony WWW
# 
# URL: Adres strony, z ktrej chcesz wydoby informacje

require 'getoptlong'
require 'rdoc/ri/ri_paths'
require 'rdoc/usage'
require 'rio'
require 'open-uri'
require 'uri'
require 'mechanize'
require 'pathname'

#Wydobywanie odnonikw.
def links(site)
  links_file = File.open("links.txt","w+b")
  agent = WWW::Mechanize.new

  begin
    page = agent.get(site.strip)
    
    #Pobieranie kadego odnonika.
    page.links.each do |l|
      if l.href[0..3] == "http"
        links_file.puts l.href                
      elsif (l.href.split("")[0] == '/' and site.split("").last != '/') or
          (l.href.split("")[0] != '/' and site.split("").last == '/')
        links_file.puts "#{site}#{l.href}"
      elsif l.href.split("")[0] != '/' and site.split("").last != '/'
        links_file.puts "#{site}/#{l.href}"
      else
        links_file.puts l.href
      end
    end
  rescue => e
    puts "Wystpi bd."
    puts e
  end
  links_file.close
end

#Wydobywanie rysunkw.
def images(site)
  begin
    #czenie si z witryn.
    open(site.strip, "User-Agent" => "Mozilla/4.0 (compatible; MSIE 5.5; Windows 98)") do |source|
      source.each_line do |x|        
        #Wyszukiwanie znacznikw img.
        if x =~ /<img src="(.+.[jpeg|gif])"\s+/

          name = $1.split('"').first
          site = site + '/' unless site.split("").last == '/'
          name = site + name unless name[0..3] == "http"
          copy = name.split('/').last

          File.open(copy, 'wb') do |f|
            f.write(open(name).read)
          end
        end
      end
    end
  rescue => e
    puts "Wystpi bd - sprbuj ponownie."
    puts e
  end
end

#Wydobywanie kodu rdowego strony.
def page(site)
  rio(site) > rio("#{URI.parse(site.strip).host}.html")
end

#Definicje wszystkich argumentw przyjmowanych w wierszu polece.
opts = GetoptLong.new(
  [ '--help', '-h', GetoptLong::NO_ARGUMENT ],
  [ '--links', '-l', GetoptLong::NO_ARGUMENT ],
  [ '--images', '-i', GetoptLong::NO_ARGUMENT ],
  [ '--page', '-p', GetoptLong::NO_ARGUMENT ]
)

unless ARGV[0]
  puts "\nNie podae adresu URL (wyprbuj opcj --help)"
  exit
end

url = ARGV[-1].chomp

#Bloki powizane z rnymi argumentami z wiersza polece.
opts.each do |opt, arg|
  case opt
  when '--help'
    RDoc::usage
  when '--links'
    links(url)
  when '--images'
    images(url)
  when '--page'
    page(url)
  else
    RDoc::usage
  end
end
