require 'zip/zip'
require 'fileutils'

unless ARGV[0]
  puts "Sposb uycia: ruby decompress.rb <nazwaplikuzip.zip>"
  puts "Przykad: ruby decompress.rb myfile.zip"
  exit
end

archive = ARGV[0].chomp

if File.exists?(archive)  
  print "Podaj ciek do katalogu, w ktrym chcesz zapisa
    pliki (wpisz \'.\' jeli, chcesz uy biecego folderu): "
  extract_dir = $stdin.gets.chomp
  begin
    #Otwieranie istniejcego pliku zip.
    Zip::ZipFile::open(archive) do |zipfile|
      zipfile.each do |f|
        #Pobieranie wszystkich plikw.
        path = File.join(extract_dir, f.name)
        FileUtils.mkdir_p(File.dirname(path))
        zipfile.extract(f, path) 
      end
    end
  rescue Exception => e
    #Jeli w skrypcie wystpi bd, zwykle program zakoczy dziaanie w tym miejscu.
    puts "W czasie rozpakowywania wystpi bd: \n #{e}."
  end
else
  puts "\n\nNie mona znale archiwum."
end
