# Definicja metod egzemplarza trace! i untrace! dla wszystkich obiektw.
# Metoda trace! tworzy acuch wyznaczonych metod, definiujc metody singletonowe,
# ktre dodaj funkcjonalno ledzenia, a nastpnie wywoujc orygina za pomoc metody super.
# Metoda untrace! usuwa te metody singletonowe, aby pozby si funkcjonalnoci ledzenia.
class Object
  # ledzi wyznaczone metody, wysyajc dane do strumienia STDERR.
  def trace!(*methods)
    @_traced = @_traced || []    # Zapamituje zbir ledzonych metod.
    # Jeli nie zostay wyznaczone adne metody, zostan wzite pod uwag wszystkie metody publiczne
    # zdefiniowane bezporednio (nie odziedziczone) w klasie tego obiektu.
    methods = public_methods(false) if methods.size == 0
    methods.map! {|m| m.to_sym } # Konwertuje wszystkie acuchy na symbole.
    methods -= @_traced          # Usuwa metody, ktre s ju ledzone.
    return if methods.empty?     # Koczy dziaanie wczeniej, jeli nie ma nic do zrobienia.
    @_traced |= methods          # Dodaje metody do zbioru metod ledzonych.
    # ledzi fakt rozpoczcia ledzenia tych metod.
    STDERR << "ledzenie #{methods.join(', ')} w #{object_id}\n"
    # Metody singletonowe s zdefiniowane w klasie eigenclass.
    eigenclass = class << self; self; end
    methods.each do |m|         # Dla kadej metody m.
      # Definicja ledzonej wersji singletonowej metody m.
      # Wysya informacje ledzenia i wywouje za pomoc metody super
      # metod egzemplarza, ktr ledzi.
      # Chcesz, aby definiowane metody mogy przyjmowa bloki, a wic
      # nie moesz uy metody define_method, tylko musisz w zamian wykona acuch.
      # Zauwa, e wszystko, co znajduje si pomidzy znakami %Q{ i pasujcym znakiem } jest
      # acuchem w podwjnych cudzysowach, nie blokiem. Zauwa take, e s
      # dwa poziomy interpolacji acuchw. #{} jest interpolowany, gdy
      # definiowana jest metoda singletonowa. acuch \#{} jest interpolowany, gdy
      # metoda ta jest wywoywana.
      eigenclass.class_eval %Q{
        def #{m}(*args, &block)
          begin
            STDERR << "Wchodzenie: #{m}(\#{args.join(', ')})\n"
            result = super
            STDERR << "Wychodzenie: #{m} z wartoci \#{result}\n"
            result
          rescue
            STDERR << "Anulowanie: #{m}: \#{$!.class}: \#{$!.message}"
            raise
          end
        end
      }
    end
  end
  # Wycza ledzenie wyznaczonych metod lub wszystkich ledzonych metod.
  def untrace!(*methods)
    if methods.size == 0    # Jeli nie zostaa podana adna metoda,
      methods = @_traced    # wszystkie aktualnie ledzone metody przestan by ledzone.
      STDERR << "Wyczanie ledzenia wszystkich metod obiektu #{object_id}\n"
    else                    # W przeciwnym przypadku wycza ledzenie.
      methods.map! {|m| m.to_sym }  # Konwertuje acuchy na symbole.
      methods &= @_traced   # wszystkich wyznaczonych metod, ktre s ledzone.
      STDERR << "Wyczanie ledzenia #{methods.join(', ')} w #{object_id}\n"
    end
    @_traced -= methods     # Usunicie tych metod ze zbioru metod ledzonych.
    # Usuwa ledzone metody singletonowe z klasy eigenclass.
    # Zauwa, e wykonujesz tu za pomoc metody class_eval blok kodu, nie acuch.
    (class << self; self; end).class_eval do
      methods.each do |m|
        remove_method m     # Metoda undef_method nie dziaaaby prawidowo.
      end
    end
    # Jeli adne wicej metody nie s ledzone, usuwasz zmienn egzemplarza.
    if @_traced.empty?
      remove_instance_variable :@_traced
    end
  end
end
