class Module
  private     # Ponisze metody s prywatne.
  # Ta metoda dziaa jak metoda attr_reader, ale ma krtsz nazw.
  def readonly(*syms)
    return if syms.size == 0  # Jeli nie ma argumentw, nie robi nic.
    code = ""                 # Na pocztku jest pusty acuch.
    # Generuje acuch kodu Ruby definiujcy metody odczytujce atrybuty.
    # Zauwa interpolacj symbolu do acucha kodu.
    syms.each do |s|                     # Dla kadego symbolu
      code << "def #{s}; @#{s}; end\n"   # definiowana jest metoda.
    end
    # Tworzenie metod egzemplarza z wygenerowanego kodu za pomoc metody class_eval.
    class_eval code
  end
  # Ta metoda dziaa jak metoda attr_accessor, ale ma krtsz nazw.
  def readwrite(*syms)
    return if syms.size == 0
    code = ""
    syms.each do |s|
      code << "def #{s}; @#{s} end\n"
      code << "def #{s}=(value); @#{s} = value; end\n"
    end
    class_eval code
  end
end
