class BuyController < ApplicationController

  def index
    @items = Item.return_items
  end

  def add
    item = Item.find(params[:id])
    @cart = get_cart
    @cart.add_purchase(item)
    session[:shopping_cart] = @cart
    redirect_to(:action => 'display_cart')
  end

  def display_cart
    @cart = get_cart
    @purchases = @cart.purchases
    @price = @cart.price
  end

  def clear_cart
    @cart = get_cart
    @cart.clear
  end

private
  def get_cart
    if session[:shopping_cart] 
      return session[:shopping_cart]
    else
      return Cart.new
    end
  end
end

