#!/usr/bin/env ruby

title = String.new # => ""
title.empty? # => true
title.length
title.size # => 0
title = String.new( "Wiele haasu o nic" )
title.empty? # => false
title.length # => 22
title = String( "Wiele haasu o nic" )
puts title # => Wiele haasu o nic
sad_love_story = "Romeo i Julia"
sad_love_story = 'Romeo i Julia'

lear = "Krl Lear\nTragedia\nWilliam Szekspir"
puts lear # => Krl Lear
          #    Tragedia
          #    William Szekspir
lear = 'Krl Lear\nTragedia\nWilliam Szekspir'
puts lear # => Krl Lear\nTragedia\nWilliam Szekspir

comedy = %!Jak wam si podoba!
history = %[Krl Henryk V]
tragedy = %(Juliusz Cezar)

sonnet = <<29
Gdy los i ludzie czstuj mnie wzgard,
Chc miosierdzie wzbudzi w guchym niebie; 
Pacz i al si na dol tward,
I kln upadek mj patrzc na siebie. 
Chc mie bogatsz nadziej przyszoci, 
Mie rysy innych i przyjaci rzesz, 
Dobra jednego, innego zdolnoci,
Gdy tym, co moje, zgoa si nie ciesz. 
Lecz gdy od myli tych brzydnie mi ycie, 
Wraca o tobie myl, a moja dusza
Niby skowronek zrywa si o wicie
I hymn podnoszc, bramy niebios wzrusza;
Gdy twej mioci najsodsze wspomnienie
Sprawia, e z krlem losu nie zamieni.
29
puts sonnet

sonnet = <<hamlet # to samo co acuch w nawiasach podwjnych
O, moja wieszcza duszo!
hamlet

sonnet = <<"hamlet" # ponownie, teraz w nawiasach podwjnych
O, moja wieszcza duszo!
hamlet

sonnet = <<'ghost' # ponownie, teraz w nawiasach pojedynczych
Nie lituj si nade mn, ale bacznym 
Uchem ogarnij to, co ci mam odkry.
ghost

my_dir = <<`dir` # tak samo, z  lewymi apostrofami
ls -l
dir

ind = <<-hello # dla wcicia
    Witaj, Matz!
hello

"Witaj," " " "Matz" "!" # => "Witaj, Matz!"
"Witaj," + " " + "Matz" + "!" # => "Witaj, Matz!"
"Witaj, " << "Matz!" # => "Witaj, Matz!"
"Witaj," << " " << "Matz" << "!" # => "Witaj, Matz!"
"Witaj, ".concat "Matz!"
h = "Witaj, "
m = "Matz!" 
h.concat(m)
greet = "Witaj, Matz!"
greet.freeze

# sprbujmy co doczy
greet.concat("!") # => TypeError: cant modify frozen string

# czy obiekt jest zamroony?
greet.frozen? # => true

line = "Konia! konia! krlestwo za konia!"
cite = "Akt V, scena IV"
speaker = "Krl Ryszard III"

speaker['Krl'] # => "Krl"

line[5] # => 33
line[5].chr # => "!"
line[14, 19] # => "krlestwo za konia!"
line[14, 19].capitalize # => "Krlestwo za konia!"

cite[0..4] # => "Akt V"
cite[0...4] # => "Akt "
line[/konia!$/] # => "konia!" 
line[/Konia!/, 0] # => "Konia!" 
line.index("r") # => 15
line[line.index("r")] # => 114
line[line.index("r")].chr # => "r"


hay = "Four score and seven years ago our fathers brought forth, upon this continent, a new nation, conceived in Liberty, and dedicated to the proposition that all men are created equal."

nicolay = "Four score and seven years ago our fathers brought forth, upon this continent, a new nation, conceived in liberty, and dedicated to the proposition that \"all men are created equal\""
hay == nicolay # => false
hay.eql? nicolay # => false

"a" <=> "a" # => 0
"a" <=> 97.chr # => 0
"a" <=> "b" # => -1
"a" <=> "`" # => 1
"a" <=> "A"
"a".casecmp "A" # => 0
"ferlin husky".casecmp "Ferlin Husky" # => 0
"Ferlin Husky".casecmp "Lefty Frizzell" # => -1

"Konia! " * 2 # => "Konia! Konia! "
taf = "Thats ".downcase * 3 + "all folks!" # => "thats thats thats all folks!"
taf.capitalize # => "Thats thats thats all folks!"

"Bdci cicho.".insert 7, "e" # => "Bdcie cicho."
"Bdcie cicho.".insert 8, "badzo " # => "Bdcie badzo cicho."
"Bdcie cicho.".insert 8, "badzo " * 3 # => "Bdcie badzo badzo badzo cicho."

line = "Porsche! Porsche! krlestwo za porsche!"
cite = "Akt V, scena V"
speaker = "Krl Ryszard, 2007"
speaker[", 2007]= " III" # => " III"
p speaker # => " Krl Ryszard III"
cite[13]= "IV" # => "IV"
p cite # => "Akt V, scena IV"
line[31,8]= "Porsche 911 Turbo!""
p line # => "Porsche! Porsche! krlestwo za Porsche 911 Turbo!"

speaker[13..15]= "Trzeci" # => "Trzeci"
p speaker # => "Krl Ryszard Trzeci"
line[/Porsche!$/]= "Porsche Targa!" # => "Porsche Targa!"
p line # => "Porsche! Porsche! krlestwo za Porsche Targa!"

lear = <<limerick
Raz y pewien pan w Tasmanii, 
co dzieckiem w kolebce spad w czajnik. 
  A e rs wszerz i wzdu, 
  nie wydosta si ju. 
I tak zosta w czajniku w Tasmanii.
limerick # => "Raz y pewien pan w Tasmanii,\nco dzieckiem w kolebce spad w czajnik.\n  A e rs wszerz i wzdu,\n   nie wydosta si ju.\nI tak zosta w czajniku w Tasmanii.\n" 
limerick.chomp! # => "Raz y pewien pan w Tasmanii,\nco dzieckiem w kolebce spad w czajnik.\n  A e rs wszerz i wzdu,\n   nie wydosta si ju.\nI tak zosta w czajniku w Tasmanii."
limerick.chomp! # => nil
limerick.chop! = ""Raz y pewien pan w Tasmanii,\nco dzieckiem w kolebce spad w czajnik.\n  A e rs wszerz i wzdu,\n  nie wydosta si ju.\nI tak zosta w czajniku w Tasmanii"


"That's call folks!".delete "c" # => "That's all folks"
"That's alll folks".delete "l" # => "That's a foks"
"That's alll folks".delete "ll" # => "That's a foks"
"That's all folks".delete "abcdefghijklmnopqrstuvwxyz", "^ha" # => "haa"

"That's alll folks".gsub "alll", "all" # => "That's all folks"
"That's alll folks".gsub "lll", "ll" # => "That's all folks"

call = "Wszystkie rce na pokad!"
call.replace "Wszystkie nogi na pokad!" # => " Wszystkie nogi na pokad!"
call = "Wszystkie rce na pokad!"
call = "Wszystkie nogi na pokad!"

# ten sam obiekt
call = "Wszystkie rce na pokad!" # => "Wszystkie rce na pokad!"
call.object_id # => 1624370
call.replace "Wszystkie nogi na pokad!" # => "Wszystkie nogi na pokad!"
call.object_id # => 1624370

# inny obiekt
call = "Wszystkie rce na pokad!" # => "Wszystkie rce na pokad!"
call.object_id # => 1600420
call = "Wszystkie nogi na pokad!" # => "Wszystkie nogi na pokad!"
call.object_id # => 1009410

"abcdefghijklmnopqrstuvwxyz".reverse # => "zyxwvutsrqponmlkjihgfedcba"
palindrome = "orkom mokro"
palindrome.reverse! # => "orkom mokro"
p palindrome

"0123456789".split # => ["0123456789"]
"0123456789".split( // ) # => ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9"]

c_w = "George Jones, Conway Twitty, Lefty Frizzell, Ferlin Husky" 
# => "George Jones, Conway Twitty, Lefty Frizzell, Ferlin Husky"
c_w.split(/, /) # => ["George Jones", "Conway Twitty", "Lefty Frizzell", "Ferlin Husky"]

"Dla jzyka Ruby w kocu powstaa doskonaa aplikacja. Jest ni Ruby on Rails.".capitalize # => " Dla jzyka ruby w kocu powstaa doskonaa aplikacja. jest ni ruby on rails."

"nowy\notwrz\nzamknik\ndrukuj".each { |item] puts item.capitalize } # =>
# Nowy
# Otwrz
# Zamknij
# Drukuj

"matz".each_byte { |b| print b, "/" } # => 109/97/116/122/
"matz".each_byte { |b| print b.chr, "/" } # => m/a/t/z/
out = [] # tworzymy pust tablic
"matz".each_byte { |b| p out << b} # =>
# => [109]
# => [109, 97]
# => [109, 97, 116]
# => [109, 97, 116, 122]
p out # => [109, 97, 116, 122]

"CZYTANIE TEKSTU ZOONEGO Z SAMYCH WIELKICH LITER MOE BY NADER IRYTUJCE.".downcase # => "czytanie tekstu zoonego z samych wielkich liter moe by nader irytujce."

"CZYTANIE TEKSTU ZOONEGO Z SAMYCH WIELKICH LITER MOE BY NADER IRYTUJCE.".downcase.capitalize # => "Czytanie tekstu zoonego z samych wielkich liter moe by nader irytujce."

"uwaga! klawiatura moe by gorca!".upcase # => "UWAGA! KLAWIATURA MOE BY GORCA!"

"aAbBcCdDeEfFgGhHiI".swapcase # => "AaBbCcDdEeFfGgHhIi"


title = "Stracone zachody mioci"
title.size # => 24
title.ljust 20 # => "Stracone zachody mioci"
title.rjust 24 # => "Stracone zachody mioci" 
title.ljust 25 # => "Stracone zachody mioci "
title.rjust 30 # => "      Stracone zachody mioci" 
title.rjust( 26, "-" ) # => "--Stracone zachody mioci"
title.rjust 30, "->" # => "->->->Stracone zachody mioci"
title.rjust(25, "-").ljust(26, "-") # => "-Stracone zachody mioci-"
title.center 28 # => " Stracone zachody mioci "
title.center 28, "-" # => "--Stracone zachody mioci--"

filename = "hack.rb" # => "hack.rb"
filename.size # => 7
filename.center 40-7, "#" # => "#############hack.rb#############"

fear = "          W ciemni strachu powstaj wycznie czarne obrazy. -- Michael Pritchard             "

fear.lstrip! # => "W ciemni strachu powstaj wycznie czarne obrazy. -- Michael Pritchard             "
fear.rstrip! # => "W ciemni strachu powstaj wycznie czarne obrazy. -- Michael Pritchard"
fear.strip! # => "W ciemni strachu powstaj wycznie czarne obrazy. -- Michael Pritchard"
"\t\tegnajcie, znaki tabulacji i koca wiersza!\r\n".strip # => "egnajcie, znaki tabulacji i koca wiersza!"

"a".next
"a".succ # => "b"
"aa".next # => "ab"
"z".next # => "aa" # dwie litery a po jednej z
"zzzz".next # => "aaaaa" # pi liter a po czterech z
"999.0".next # => "999.1" # inkrementacja o .1
"999".next # => "1000" # inkrementacja z 999 na 1000
" ".next # => "!"
"0".next.next.next # => "3"
"2007".next # => "2008"
2008.next # => 2009
120.chr # => "x"
120.chr.next # => "y"

"a".upto("z") { |i| print i } # => abcdefghijklmnopqrstuvwxyz

for i in "a".."z"
  print i
end

"200".class # => String
"200".to_f # => 200.0
"200".to_f.class # => Float
"100".class # => String
"100".to_i # => 100
"100".to_i.class # => Fixnum
"name".intern # => :name
"name".to_sym # => :name
play = "Kupiec wenecki".intern # => :"Kupiec wenecki"
(256.0).class # => Float
(256.0).to_s # => "256.0"

opening = "Gdy los i ludzie czstuj mnie wzgard,\nChc miosierdzie wzbudzi w guchym niebie;\n"
opening.grep(/ludzie/) # => ["Gdy los i ludzie czstuj mnie wzgard,\n"]
opening.grep(/l[uo]dzien/) # => ["Gdy los i ludzie czstuj mnie wzgard,\n"]
opening.grep(/ludzie|lodzie/) # => ["Gdy los i ludzie czstuj mnie wzgard,\n"]
opening.grep(/l(u|o)dzie/) # => ["Gdy los i ludzie czstuj mnie wzgard,\n"]
opening.grep(/^Gdy/) # => ["Gdy los i ludzie czstuj mnie wzgard,\n"]
opening.grep(/niebie;$/) # => ["Chc miosierdzie wzbudzi w guchym niebie;\n"]
opening.grep(/\AGdy/) # => ["Gdy los i ludzie czstuj mnie wzgard,\n"]
opening.grep(/niebie;\z/) # => ["Chc miosierdzie wzbudzi w guchym niebie;"]

phone.grep(/[\(\d\d\d\)]?\d\d\d-\d\d\d\d/) # => ["(555)123-4567"]
color.grep(/colou?r/) # => ["I think that colour is just right for you office."] 
phone.grep(/[\(\d+\)]?\d+-\d+/) # => ["(555)123-4567"]
phone.grep(/[\(\d{3}\)]?\d{3}-\d{4}/)# => ["(555)123-4567"]
color =~ /colou?r/ # => 13
color !~ /colou?r/ # => false
