#!/usr/bin/env ruby
# Ta klasa udostpnia kilka metod do obliczania stp finansowych.
# Jak na razie dostpne s trzy:
# 1. Stosunek zaduenia do pozostaej wartoci (_der_)
# 2. Stopa dugu dugoterminowego (_ltdr_)
# 3. Cakowita stopa dugu (_tdr_)
#
# Autor:: Mike Fitzgerald (mailto:mike@example.com)
# Copyright:: Wy'east Communications 
#
# :title:Ratios

class Ratios

# Metoda klasy +new+ inicjalizuje klas.
# === Parametry
# * _debt_ = dug dugoterminowy
# * _equity_ = warto pozostaa po spacie dugu
# === Przykad
#  ratios = Ratios.new( 2456, 9876 )

 def initialize( debt, equity )
   @debt = debt
   @equity = equity 
 end

# Metoda <tt>ltdr</tt> zwraca stop dugu dugoterminowego.
# === Wzr
#     dug dugoterminowy 
#  -------------------- = stopa dugu dugoterminowego
#  dug/warto pozostaa 
# === Parametry
# Parametry to:
# * <i>debt</i> = dug dugoterminowy
# * <i>equity</i> = warto pozostaa
# === Przykad
#  ratios = Ratios.new( 2456, 9876 )
#  ratios.ltdr # => Stopa dugu dugoterminowego wynosi 0.20.
#  ratios.ltdr 1234, 56789 # => Stopa dugu dugoterminowego wynosi 0.02.

 def ltdr( debt=@debt, equity=@equity )
   ratio = debt/(debt+equity).to_f
   printf( "Stopa dugu dugoterminowego wynosi %.2f.\n", ratio )
   ratio
 end

# Metoda <tt>der</tt> zwraca stosunek dug/warto pozostaa.
# === Wzr
#   dug dugoterminowy
#  -------------------- = stosunek dug/warto pozostaa
#    warto pozostaa
# === Parametry
# Parametry to:
# * <i>debt</i> = dug dugoterminowy
# * <i>equity</i> = warto pozostaa
# === Przykad
#  ratios = Ratios.new( 2456, 9876 )
#  ratios.der # => Stosunek dug/warto pozostaa wynosi 0.25.
#  ratios.der( 1301, 7690 ) # => Stosunek dug/warto pozostaa wynosi 0.17.

 def der( debt=@debt, equity=@equity )
   ratio = debt/equity.to_f
   printf( "Stosunek dug/warto pozostaa wynosi %.2f.\n", ratio )
   ratio
 end

# Metoda klasy +tdr+ zwraca cakowit stop zaduenia.
# === Wzr
#    nalenoci razem
#  -------------------- = cakowita stopa zaduenia
#      aktywa razem
# === Parametry
# Parametry to:
# * _liabilities_ = nalenoci razem
# * _assets_ = aktywa razem
# === Przykad
#   Ratios.tdr( 14_000, 23_000 ) # => Cakowita stopa zaduenia wynosi 0.61.

 def Ratios.tdr( liabilities, assets )
   ratio = liabilities/assets.to_f
   printf( "Cakowita stopa zaduenia wynosi %.2f.\n", ratio )
   ratio
 end

end
