

import urllib.request
import json
import pandas as pd
from pycaret.classification import *



def consumeAzureMLEndpoint(url, api_key, obs_df):
    # Tutaj powinny się znaleźć dane żądania
    json_records_str = obs_df.to_json(orient='records')
    data_str = f'{{"data":{json_records_str}}}'
    data = json.loads(data_str)

    headers = {'Content-Type':'application/json', 'Authorization':('Bearer '+ api_key)}
    body = str.encode(json.dumps(data))

    req = urllib.request.Request(url, body, headers)

    try:
        response = urllib.request.urlopen(req)
        j = json.loads(json.loads(response.read()))
        result = pd.json_normalize(j,record_path='result').set_axis(['predicted_label'],axis=1)

    except urllib.error.HTTPError as error:
        print("Żądanie nie powiodło się z kodem odpowiedzi: " + str(error.code))

        # Wyświetl nagłówki — zawierają identyfikator zapytania i znacznik czasu, które są przydatne do debugowania błędu
        print(error.info())
        print(json.loads(error.read().decode("utf8", 'ignore')))

        result = None
    
    return result


url = '<url-twojego-punktu-końcowego>'
# Ze względów bezpieczeństwa możesz ustawić klucz w zmiennej środowiskowej
# i pobrać go stamtąd w tym skrypcie. For simplicity we define it here directly.
api_key = '<klucz-twojego-punktu-końcowego>' # Zastąp go kluczem API dla usługi sieciowej


# Odkomentuj kod, jeśli nie używasz w Power BI
# w celu załadowania imputowanego zbioru danych testowych
# dataset = pd.read_csv(r'C:\<twoja-ścieżka>\Chapter13\titanic-test.csv',
#                       index_col=False)

obs = dataset.drop('Survived',axis=1)


predictions = consumeAzureMLEndpoint(url, api_key, obs)
predictions


scored_df = pd.concat([dataset, predictions],axis=1)
scored_df


