
library(dplyr)
library(ggplot2)
library(mice)

# Funkcja obliczająca macierz korelacji dla liczbowej ramki danych 
# imputacja brakujących wartości w ramce danych za pomocą metody MICE  
corr_impute_missing_values <- function(df, m = 5, variables, method = c('pearson', 'spearman')) {
  
  method <- method[1]
  
  df_imp_lst <- mice(df, m = m, printFlag = FALSE)
  
  corr_tbl <- miceadds::micombine.cor(df_imp_lst, variables = variables,
                                      method = method) %>% 
    as_tibble() %>% 
    arrange( variable1, variable2 )
  
  return( corr_tbl )
}


# Ładowanie danych 
dataset_url <- 'http://bit.ly/titanic-dataset-csv'
tbl <- readr::read_csv(dataset_url)
tbl

# Ponieważ 77% wartości w kolumnie Cabin to wartości null, kolumna Cabin zostanie usunięta 
# Usuniemy także kolumny Name i Ticket, ponieważ zawierają zbyt wiele odrębnych wartości
# Zachowajmy tylko zmienne numeryczne
tbl_cleaned <- tbl %>% 
  select( -Cabin, -Name, -Ticket ) %>% 
  mutate(
    Survived = as.factor(Survived),
    Sex = as.factor(Sex),
    Embarked = as.factor(Embarked)
  )

# Uzyskaj indeksy kolumn numerycznych
numeric_col_idxs <- which(sapply(tbl_cleaned, is.numeric))

# Oblicz obiekt tibble korelacji dla zmiennych numerycznych za pomocą metody Pearsona
# Zaimplementowana jest także metoda Spearmana 
corr_tbl <- corr_impute_missing_values(tbl_cleaned, variables = numeric_col_idxs,
                                       method = 'pearson')

corr_tbl

