
library(tidyverse)
library(timetk)

# Załaduj zestaw danych 'population'
# dostarczony przez pakiet tidyr
data("population")

# Zagnieżdżamy dane roku ('year') i populacji ('population')
# do innego obiektu tibble dla każdego kraju
nested_population_tbl <- population %>% 
  tidyr::nest( demographic_data = -country )


# Spróbujmy wykreślić szeregi czasowe wzrostu populacji dla Szwecji
selected_country <- "Szwecja"
  
nested_population_tbl %>% 

  # Pobierz wiersz powiązany z wybranym krajem
  filter( country == selected_country ) %>%   
  # Pobierz zawartość 'demographic_data' dla
  # tego wiersza. Zauważ, że to jest lista
  pull( demographic_data ) %>%
  
  # Wyodrębnij tibble "demographic_data" z
  # listy (złożonej tylko z 1 elementu)
  pluck(1) %>% 
  
  # Teraz wykreśl szeregi czasowe deklarując zmienną date
  # i wartość jeden. 
  timetk::plot_time_series(
    .date_var = year,
    .value = population,
    .title = paste0("Globalna populacja ", selected_country),
    
    .smooth = FALSE,     # --> usuń gładką linię
    .interactive = FALSE # --> wygeneruj statyczny wykres
  )


# Wygenerujmy wykres szeregów czasowych, jak pokazano powyżej
# dla każdego wybranego kraju i utrwalmy wynik
# w kolumnie 'plot' do zagnieżdżonego obiektu tibble
nested_population_plots_tbl <- nested_population_tbl %>%

  # Wybierz podzbiór krajów
  filter( country %in% c("Włochy", "Szwecja", "Francja", "Niemcy") ) %>%

  # Dodaj nową kolumnę o nazwie 'plot' poprzez zastosowanie funkcji plot_time_series
  # do wartości tibble demographic_data (.x)
  # dla każdego kraju (.y) w polu 'country'.
  # Zrób to za pomocą funkcji map2.
  mutate(
    plot = map2( demographic_data, country, ~ timetk::plot_time_series(
      .data = .x,
      .date_var = year,
      .value = population,
      .title = paste0("Globalna populacja ", y),
      .smooth = FALSE,
      .interactive = FALSE) )
  ) %>%

  # Zwróć tylko kolumny 'country' i 'plot'.
  select( country, plot )


# Teraz wyodrębnij  z zagnieżdżonego obiektu tibble nazwaną listę wykresów dla każdego kraju.
plots_lst <- nested_population_plots_tbl %>% 
  
  # konwersja dwukolumnowych ramek danych na nazwaną listę, z wykorzystaniem
  # pierwszej kolumny jako nazwa i drugiej kolumny jako wartości
  deframe()


# Serializuj listę wykresów
saveRDS(plots_lst, "plots_lst.rds")

