export function getValue(object, propertyName, defaultValue) {
    if (!object) {
        return defaultValue;
    }
    let propertyValue = object[propertyName];
    if (propertyValue === undefined) {
        return defaultValue;
    }
    return propertyValue;
}
/** Gets the solid color from a fill property using only a propertyName */
export function getFillColorByPropertyName(object, propertyName, defaultColor) {
    let value = getValue(object, propertyName);
    if (!value || !value.solid) {
        return defaultColor;
    }
    return value.solid.color;
}
//# sourceMappingURL=dataViewObject.js.map