# TEN SKRYPT MA BYĆ URUCHAMIANY W JUPYTER NOTEBOOK (UŻYŁEM VS CODE)

# %%
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import seaborn as sb
from statsmodels.graphics.mosaicplot import mosaic
from dython.nominal import cramers_v
from dython.nominal import theils_u
from dython.nominal import correlation_ratio
from dython.nominal import associations

# %%
def violinPlot(data, varx, vary, title, xlab, ylab, hue = None):
    hplot = sb.violinplot(x=varx, y=vary, hue=hue, split=(hue is not None), data=data)
    plt.title(title, fontsize=18)
    plt.xlabel(xlab, fontsize=16)
    plt.ylabel(ylab, fontsize=16)
    
    return hplot


# %%
# Załaduj zestaw danych o katastrofie Titanica
dataset_url = 'http://bit.ly/titanic-dataset-csv'

df = pd.read_csv(dataset_url)
df.head()

# %%
# Przekształć zmienne kategoryczne na tekstowe kolumny
categ_cols = ['Survived', 'Pclass']
df[categ_cols] = df[categ_cols].astype(str) 
df

# %%
# Obliczenie współczynnika V Craméra dla kolumn Survived i Pclass
cramers_v(df['Survived'], df['Pclass'], bias_correction=False)

# %%
# Weryfikujemy, czy funkcja V Craméra jest symetryczna
cramers_v(df['Survived'], df['Pclass']) == cramers_v(df['Pclass'], df['Survived'])

# %%
# Możesz także narysować dla tych zmiennych wykres mozaikowy
mosaic(data=df, index=['Survived', 'Pclass'], statistic=True, axes_label=True, gap=[0.01,0.02])

# %%
# Skorzystaj z asymetrii funkcji U Theila poprzez obliczenie jej dla tych samych zmiennych.
# To jest wartość U(Survived|Pcalss), tzn. "U dla wartości Survived oraz danej wartości Pclass"
theils_u(df['Survived'], df['Pclass'])

# %%
# Sprawdzenie, czy wywołanie funkcji w przeciwnym kierunku daje inny wynik 
theils_u(df['Pclass'], df['Survived'])

# %%
# Narysowanie wykresu skrzypcowego dla zmiennych Age i Pclass
violinPlot(data=df, varx='Pclass', vary='Age',
           title='Wiek pasażera a klasa pasażera',
           xlab='Pclass', ylab='Age')
# W przypadku, gdy nie korzystasz z notebooka Jupyter, uruchom również następującą instrukcję: 
# plt.show()

# %%
# Możesz także wyświetlić rozkład trzeciego wymiaru (w tym przypadku Survived)
# pokolorowanie połowy wykresu skrzypcowego
violinPlot(data=df, varx='Pclass', vary='Age', hue='Survived',
           title='Wiek pasażera a klasa pasażera',
           xlab='Pclass', ylab='Age')
# W przypadku, gdy nie korzystasz z notebooka Jupyter, uruchom również następującą instrukcję: 
# plt.show()

# %%
# Obliczenie współczynnika korelacji pomiędzy kategoryczną zmienną Pclass, a 
# liczbową zmienną Age
correlation_ratio(categories=df['Pclass'], measurements=df['Age'])

# %%
# Pokażmy, w jaki sposób zmieni się współczynnik korelacji po zmianie rozproszenia obserwacji dla każdej kategorii 
t1 = pd.DataFrame(
    {
        'topic': ['Algebra','Algebra','Algebra','Algebra','Algebra','Geometry','Geometry','Geometry','Geometry','Statistics','Statistics','Statistics','Statistics','Statistics','Statistics'],
        'score': [45,70,29,15,21,40,20,30,42,65,95,80,70,85,73]
    }
)

violinPlot(data=t1, varx='topic', vary='score',
           title='', xlab='',ylab='')
# W przypadku, gdy nie korzystasz z notebooka Jupyter, uruchom również następującą instrukcję: 
# plt.show()

# %%
correlation_ratio(categories=t1['topic'], measurements=t1['score'])

# %%
t2 = pd.DataFrame(
    {
        'topic': ['Algebra','Algebra','Algebra','Algebra','Algebra','Geometry','Geometry','Geometry','Geometry','Statistics','Statistics','Statistics','Statistics','Statistics','Statistics'],
        'score': [36,36,36,36,36,33,33,33,33,78,78,78,78,78,78]
    }
)

violinPlot(data=t2, varx='topic', vary='score',
           title='', xlab='',ylab='')

# %%
correlation_ratio(categories=t2['topic'], measurements=t2['score'])

# %%
# Oblicz współczynniki korelacji dla obiektu DataFrame pakietu pandas, niezależnie od typów danych kolumn
ass = associations(df, nom_nom_assoc = 'theil', num_num_assoc = 'pearson',
                   figsize=(10,10), clustering=True)

# %%
ass['corr']

# %%
