library(dplyr)
library(ggplot2)

from_byte_string = function(x) {
  xcharvec = strsplit(x, " ")[[1]]
  xhex = as.hexmode(xcharvec)
  xraw = as.raw(xhex)
  unserialize(xraw)
}

# # Dla celów debugowania w RStudio musisz zdefiniować plots_df z pliku
# # 06-deserialize-plots-object-from-rds-in-power-bi.R. Następnie musisz
# # wybrać jeden kraj filtrując według country_name
# dataset <- plots_df %>%
#   filter( country_name == "Francja" )

# R Visual importuje tabele przy użyciu read.csv a nie ustawia strings_as_factors = F w roli parametru.
# Oznacza to, że fragmenty są importowane jako czynniki, a niektóre z nich są obcinane.
# gdy mają " " na końcu. Długość tych fragmentów będzie wynosiła 9999 zamiast 10000.
# Po prostu przekonwertuj na znak i dodaj spację, jeśli nchar == 9999 w celu wykonania
# deserializacji.
dataset <- dataset %>%
  mutate( plot_str = as.character(plot_str) ) %>%
  mutate( plot_str = ifelse(nchar(plot_str) == 9999, paste0(plot_str, " "), plot_str) )

# Posortuj zawartość ramki danych poprzez zwiększenie wartości chunk_id, aby upewnić się, że
# fragmenty ciągu są poprawnie posortowane i gotowe do deserializacji
plot_vct <- dataset %>%
  arrange(country_name, chunk_id) %>%
  pull(plot_str)

# Scal fragmenty
plot_vct_str <- paste( plot_vct, collapse = "" )

# Przekształć ciąg bajtów na obiekt języka R
plt <- from_byte_string(plot_vct_str)

# Wykreśl zmienną "plt" dodając element formatowania w celu uzyskania większego rozmiaru czcionki
plt + theme(text = element_text(size=20))
