
import pandas as pd
import pickle

# Załaduj plik "population.csv" z bieżącego folderu
population_df = pd.read_csv("population.csv")

# Pobierz wszystkie kraje z tablicy NumPy
# z ramki danych population_df. Jeśli nie rozumiesz
# różnic między tablicami, a listami,
# zajrzyj tutaj: https://learnpython.com/blog/python-array-vs-list/

countries = population_df.country.unique()

# Zdefiniuj pusty słownik
nested_population_dict = {}

# Dla każdego unikatowego kraju...
for c in countries:

    # Pobierz indeksy logiczne dla wierszy odpowiadających bieżącemu krajowi c,
    # pobierz ramkę danych zawierającą te wiersze (za pomocą funkcji loc),
    # zachowaj tylko kolumny  'year' i 'population' (za pomocą funkcji filter),
    # zresetuj indeks zaznaczonych wierszy, aby zaczynał się od  0 i na koniec
    # skojarz ramkę danych uzyskaną dla wybranego kraju c i wstaw tę parę do słownika
    nested_population_dict[c] = population_df.loc[ population_df['country'] == c ].filter(['year', 'population']).reset_index(drop=True)

# Zserializuj cały słownik i zapisz go na dysku
pickle.dump( nested_population_dict, open("nested_population_dict.pkl", "wb") )
