{************************************************}
{*                                              *}
{* Nazwa programu   :  Quick Copy               *}
{* Wersja           :  1.00                     *}
{* Kompilowane w    :  Turbo Pascal ver. 7.0    *}
{* Procesor         :  8086 i lepszy            *}
{* Co-procesor      :  niepotrzebny             *}
{* Autor            :  Buk Mariusz              *}
{* Data             :  25 VII 1995              *}
{* Miejsce          :  Polska                   *}
{*                                              *}
{* Opis:                                        *}
{*                                              *}
{*   Program umozliwia bardzo szybkie kopiowa-  *}
{*   nie danych wykorzystujac do tego celu      *}
{*   cala dostepna pamiec konwencjonalna, XMS   *}
{*   oraz UMB. Program powstal by zademonstro-  *}
{*   wac uzycie tych pamieci jako buforow       *}
{*   danych.                                    *}
{*   Realizacja na podstawie polecenia XCOPY.   *}
{*                                              *}
{************************************************}

{$F+,X+,D-,O-,I-}

Program QuickCopy;

uses XMS, Strings, Params, Utils, DOS, IOError, Objects, Crt;

const
  MaxSize = 65520;

type
  PBytesArray = ^TBytesArray;
  TBytesArray = array [1..MaxSize] of Byte;

  TMem = (umXMS, umUMB, umConv);

type

  { Obiekt analizujacy parametry dla programu. }

  PQCopyParams = ^TQCopyParams;
  TQCopyParams = object (TParametry)
    A, M, R, D, P, S, L, E, _H, V, W, _Y : Boolean;
    Rok, Miesiac, Dzien : Integer;
    function Obsluz(parametr : string) : Boolean; virtual;
    procedure Pomoc; virtual;
  end;


  { Obiekt sluzacy do zapamietywania informacji }
  { o pojedynczym bloku pliku.                  }

  PRecord = ^TRecord;
  TRecord = object (TObject)
    Size      : Word;
    Caly      : Boolean;
    Adres     : PBytesArray;
    UseMemory : TMem;
    SFileName : PString;
    DFileName : PString;
    constructor Init(ASize : Word; ACaly : Boolean; AAdres : Pointer;
      AUseMemory : TMem; const ASFileName, ADFileName : string);
    destructor Done; virtual;
  end;


  { Obiekt kopiujacy pliki. Zapis nastepuje w momencie }
  { przepelnienia bufora.                              }

  PCopy = ^TCopy;
  TCopy = object (TObject)
    FilesCopied     : Word;

    ClearArchive,
    CreateConf,
    Verify,
    ReplaceConf,
    MoveFile,
    LinkFile        : Boolean;

    private
    FilesCollection : PCollection;
    Valid           : Boolean;

    HandleXMS       : Word;
    OffsetXMS       : LongInt;
    SizeOfXMS       : LongInt;

    Buffer          : PBytesArray;
    SizeOfBuffer    : LongInt;

    FSource, FDest  : file;
    Complete        : Boolean;
    CreateFile      : Boolean;
    Opened          : Boolean;
    public
    constructor Init(AClearArchive, ACreateConf, AVerify, AReplaceConf,
      AMoveFile, ALinkFile : Boolean);
    destructor Done; virtual;
    function CopyFile(const Source, Dest : string) : Boolean;
    procedure ReadMsg(const TextMsg : string); virtual;
    procedure WriteMsg(const Textmsg : string); virtual;
    procedure Message(const TextMsg : string); virtual;
    procedure ErrorMsg(ErrCode : Integer); virtual;
    function CreateConfirmation(const FileName : string) : Byte; virtual;
    function ReplaceConfirmation(const FileName : string) : Byte; virtual;
    procedure Abort; virtual;
    private
    function FlushBuffers : Boolean;
    function SaveRData(const SFileName, DFileName : string;
      var caly : Boolean) : Boolean;
  end;

const
  wpTak       = 00;
  wpNie       = 01;
  wpAnuluj    = 02;
  wpDopisz    = 03;
  wpWszystkie = 04;

var
  parametry   : TQCopyParams;
  kod_wyjscia : Integer;

{ Sprawdzenie istnienia chociaz jednego zbioru na wskazanej sciezce. }

Function JestZbior(sciezka : PathStr) : Boolean;
var
  zbior : SearchRec;
begin
  FindFirst(sciezka, AnyFile, zbior);
  while (DosError=0) and ((zbior.Name='.') or (zbior.Name='..')) do
    FindNext(zbior);
  JestZbior:=DosError=0
end;


{ TCopy }


{ Inicjacja obiektu. Przydzielenie pamieci dla poszczegolnych elementow. }

Constructor TCopy.Init(AClearArchive, ACreateConf, AVerify, AReplaceConf,
  AMoveFile, ALinkFile : Boolean);
begin
  inherited Init;
  Valid:=True;
  Complete:=True;
  Opened:=False;
  CreateFile:=True;
  ClearArchive:=AClearArchive;
  CreateConf:=ACreateConf;
  Verify:=AVerify;
  ReplaceConf:=AReplaceConf;
  MoveFile:=AMoveFile;
  LinkFile:=ALinkFile;
  if IsXMS then
    begin
      SizeOfXMS:=XMSMemAvail;
      if SizeOfXMS>0 then XMSGetMem(HandleXMS, SizeOfXMS)
    end;
  SizeOfBuffer:=MaxAvail;
  if SizeOfBuffer>MaxSize then
    SizeOfBuffer:=MaxSize
   else
    SizeOfBuffer:=MaxAvail div 2;
  GetMem(Buffer, SizeOfBuffer);
  FilesCollection:=New(PCollection, Init(100, 50))
end;


{ Zakonczenie dzialania obiektu. Zwolnienie wszystkich blokow pamieci. }

Destructor TCopy.Done;
begin
  if FilesCollection<>nil then
    begin
      if (FilesCollection^.Count>0) and Valid then FlushBuffers;
      Dispose(FilesCollection, Done)
    end;
  if Buffer<>nil then FreeMem(Buffer, SizeOfBuffer);
  if HandleXMS<>HandleNull then XMSFreeMem(HandleXMS);
  inherited Done
end;


{ Wypisanie komunikatu o odczytywaniu pliku. }

Procedure TCopy.ReadMsg(const TextMsg : string);
begin
{  WriteLn(TextMsg)}
end;


{ Wypisanie komunikatu o zapisywaniu pliku. }

Procedure TCopy.WriteMsg(const TextMsg : string);
begin
  WriteLn(TextMsg)
end;


{ Wypisanie komunikatu o bledzie na ekran monitora. }

Procedure TCopy.ErrorMsg(ErrCode : Integer);
begin
  WriteLn(IOResultCode(ErrCode))
end;


{ Wypisanie komunikatu. }

Procedure TCopy.Message(const TextMsg : string);
begin
  WriteLn(TextMsg)
end;


{ Wstrzymanie wszystkich operacji. }

Procedure TCopy.Abort;
begin
  Valid:=False;
  kod_wyjscia:=2;
  WriteLn('Operacja przerwana.')
end;


{ Potwierdzenie utworzenia nowego zbioru. }

Function TCopy.CreateConfirmation(const FileName : string) : Byte;
var
  wybor : Char;
begin
  Write(FileName, ' (Tak/Nie/Wszystkie/Anuluj)? ');
  repeat
    wybor:=UpCase(ReadKey);
    case wybor of
      'T' : CreateConfirmation:=wpTak;
      'N' : CreateConfirmation:=wpNie;
      'W' : CreateConfirmation:=wpWszystkie;
      'A' : CreateConfirmation:=wpAnuluj
    end
  until wybor in ['T', 'N', 'A', 'W'];
  WriteLn(wybor)
end;


{ Potwierdzenie zastapienia starego zbioru. }

Function TCopy.ReplaceConfirmation(const FileName : string) : Byte;
var
  wybor : Char;
begin
  Write('Zastpi ', FileName, ' (Tak/Nie/Wszystkie/Anuluj/Dopisz)? ');
  repeat
    wybor:=UpCase(ReadKey);
    case wybor of
      'T' : ReplaceConfirmation:=wpTak;
      'N' : ReplaceConfirmation:=wpNie;
      'A' : ReplaceConfirmation:=wpAnuluj;
      'W' : ReplaceConfirmation:=wpWszystkie;
      'D' : ReplaceConfirmation:=wpDopisz
    end
  until wybor in ['T', 'N', 'A', 'W', 'D'];
  WriteLn(wybor)
end;


{ Zapisanie plikow zapamietanych w pamieci na dysk. }

Function TCopy.FlushBuffers : Boolean;

  Function ZapiszPliki(P : PRecord) : Boolean; far;
  var
    kod    : Integer;
    create : Boolean;
    tmp    : PathStr;
    plik   : file;
    atr    : Word;
    test   : Integer;
  begin
    ZapiszPliki:=False;
    if Complete then
      begin
        Create:=True;
        if CreateConf then
          case CreateConfirmation(P^.DFileName^) of
            wpTak       : CreateFile:=True;
            wpNie       : CreateFile:=False;
            wpWszystkie :
              begin
                CreateConf:=False;
                CreateFile:=True
              end;
            wpAnuluj    :
              begin
                Abort;
                ZapiszPliki:=True;
                Exit
              end
          end;
        if FileExist(P^.DFileName^) then
          if ReplaceConf then
            case ReplaceConfirmation(P^.DFileName^) of
              wpTak       : CreateFile:=True;
              wpNie       : CreateFile:=False;
              wpWszystkie :
                begin
                  ReplaceConf:=False;
                  CreateFile:=True
                end;
              wpAnuluj    :
                begin
                  Abort;
                  ZapiszPliki:=True;
                  Exit
                end;
              wpDopisz    : Create:=False
            end
           else
            Create:=not LinkFile;
        if CreateFile then
          begin
            Assign(FDest, P^.DFileName^);
            WriteMsg(LeftStr(GetFileName(P^.SFileName^), 13)+'-> '+
              GetDirName(P^.DFileName^));
            if Create then
              ReWrite(FDest, 1)
             else
              begin
                Reset(FDest, 1);
                Seek(FDest, FileSize(FDest))
              end;
            kod:=IOResult;
            if kod<>0 then
              begin
                kod_wyjscia:=5;
                ErrorMsg(kod);
                ZapiszPliki:=True;
                Valid:=False;
                Exit
              end
          end;
      end;
    if KeyPressed and (ReadKey=#27) then
      begin
        Abort;
        ZapiszPliki:=True;
        Close(FDest);
        Erase(FDest);
        Exit
      end;
    Complete:=P^.Caly;
    if not CreateFile then Exit;
    case P^.UseMemory of
      umXMS :
        begin
          XMSRunWhenError:=True;
          XMS2Mem(HandleXMS, LongInt(P^.Adres), Buffer^, P^.Size);
          XMSRunWhenError:=False
        end;
      umUMB :
        Move(Ptr(Word(P^.Adres), 0)^, Buffer^, P^.Size)
      else
        Move(P^.Adres^, Buffer^, P^.Size)
    end;
    BlockWrite(FDest, Buffer^, P^.Size);
    kod:=IOResult;
    if kod<>0 then
      begin
        kod_wyjscia:=5;
        ErrorMsg(kod);
        ZapiszPliki:=True;
        Valid:=False;
        Close(FDest);
        Erase(FDest);
        Exit
      end;
    if Complete then
      begin
        Close(FDest);
        kod:=IOResult;
        if kod=0 then
          begin
            Inc(FilesCopied);
            Opened:=False;
            Assign(plik, P^.SFileName^);
            GetFAttr(plik, atr);
            SetFAttr(FDest, atr or Archive);
            if MoveFile then
              begin
                SetFAttr(plik, 0);
                Erase(plik);
                kod:=IOResult;
                if kod<>0 then
                  begin
                    kod_wyjscia:=5;
                    ErrorMsg(kod);
                    ZapiszPliki:=True;
                    Valid:=False;
                    Exit
                  end;
                tmp:=GetDirName(P^.SFileName^);
                ClearBackSlash(tmp);
                if not JestZbior(tmp+'\*.*') then RmDir(tmp);
                kod:=IOResult
              end
             else
              if ClearArchive then SetFAttr(plik, atr and not Archive);
            kod:=IOResult;
            if kod<>0 then
              begin
                kod_wyjscia:=5;
                ErrorMsg(kod);
                ZapiszPliki:=True;
                Valid:=False;
                Exit
              end;
            if Verify then
              begin
                FileMode:=0;
                Reset(FDest, 1); kod:=0;
                FileMode:=2;
                while not Eof(FDest) and (kod=0) do
                  begin
                    BlockRead(FDest, Buffer^, SizeOfBuffer, test);
                    kod:=IOResult
                  end;
                if kod<>0 then
                  begin
                    Message('Bd podczas weryfikacji pliku.');
                    kod_wyjscia:=5;
                    ErrorMsg(kod)
                  end;
              end
          end
         else
          begin
            kod_wyjscia:=5;
            ErrorMsg(kod)
          end;
      end
     else
      Opened:=True
  end;

begin
{  if not Complete and Valid then WriteMsg(PRecord(FilesCollection^.At(0))^.DFileName^);}
  FlushBuffers:=FilesCollection^.FirstThat(@ZapiszPliki)=nil;
  FilesCollection^.FreeAll;
  OffsetXMS:=0
end;


{ Zapisanie odczytanych z dysku danych kolejno do: XMS, UMB oraz pam. konw. }

Function TCopy.SaveRData(const SFileName, DFileName : string;
  var caly : Boolean) : Boolean;
var
  bsize, usize : Word;
  wielk        : Word;
  bufor        : PBytesArray;
  Size         : Word;
  kod          : Integer;
  segment      : Word;
begin
  if KeyPressed and (ReadKey=#27) then
    begin
      Abort;
      SaveRData:=False;
      Valid:=False;
      Exit
    end;
  BlockRead(FSource, Buffer^, SizeOfBuffer, Size);
  kod:=IOResult;
  if kod<>0 then
    begin
      ErrorMsg(kod);
      kod_wyjscia:=3;
      SaveRData:=False;
      Valid:=False;
      Exit
    end;
  caly:=Eof(FSource);
  SaveRData:=True;

  { zapisanie do XMS, jezeli tylko mozna }

  if OffsetXMS+Size>SizeOfXMS then
    bsize:=SizeOfXMS-OffsetXMS
   else
    bsize:=Size;
  if bsize>0 then
    if Mem2XMS(Buffer^, HandleXMS, OffsetXMS, bsize)=xmsOk then
      begin
        XMSRunWhenError:=False;
        FilesCollection^.Insert(New(PRecord, Init(bsize, caly,
          Pointer(OffsetXMS), umXMS, SFileName, DFileName)));
        Inc(OffsetXMS, bsize);
        if Odd(OffsetXMS) then Inc(OffsetXMS)
      end
     else
      bsize:=0;

  { proba zapisu do UMB, gdy jest to mozliwe }

  usize:=0;
  if IsUMB and (bsize<Size) then
    begin
      if bsize>0 then with FilesCollection^ do PRecord(At(Count-1))^.Caly:=False;
      usize:=Size-bsize;
      if UMBMaxAvail<usize then usize:=UMBMaxAvail;
      if usize>0 then
        if UMBGetMem(segment, usize)=umbOk then
          begin
            Move(Buffer^[bsize+1], Ptr(segment, 0)^, usize);
            FilesCollection^.Insert(New(PRecord, Init(usize, caly, Pointer(segment),
              umUMB, SFileName, DFileName)))
          end
         else
          usize:=0
    end;

  { zapisanie do pam. konwencjonalnej, jezeli sie zmiesci }

  if bsize+usize<Size then
    begin
      if bsize+usize>0 then with FilesCollection^ do PRecord(At(Count-1))^.Caly:=False;
      wielk:=Size-(bsize+usize);
      if MaxAvail-MaxAvail div 3<wielk then
        begin
          wielk:=MaxAvail-MaxAvail div 3;
          Seek(FSource, FilePos(FSource)-((Size-(bsize+usize))-wielk));
          SaveRData:=False;
          caly:=False
        end;
      GetMem(bufor, wielk);
      Move(Buffer^[bsize+usize+1], bufor^, wielk);
      FilesCollection^.Insert(New(PRecord, Init(wielk, caly, bufor,
        umConv, SFileName, DFileName)))
    end
end;


{ Skopiowanie pliku o podanej nazwie do pliku o nazwie Dest. }

Function TCopy.CopyFile(const Source, Dest : string) : Boolean;
var
  caly : Boolean;
  full : Boolean;
  kod  : Integer;
begin
  CopyFile:=True;
  repeat
{    if not caly then ReadMsg(Source);}
    full:=False;
    while not full do
      begin
        if caly then
          begin
            Assign(FSource, Source);
{            ReadMsg(LeftStr(GetFileName(Source), 13)+'>> '+GetDirName(Dest));}
            FileMode:=0;
            Reset(FSource, 1);
            kod:=IOResult;
            FileMode:=2;
            if kod<>0 then
              begin
                kod_wyjscia:=3;
                ErrorMsg(kod);
                CopyFile:=False;
                Valid:=False;
                Exit
              end
          end;

        while not Eof(FSource) and not full and Valid do
          if not SaveRData(Source, Dest, caly) then full:=True;
        if not Valid then
          begin
            Close(FSource);
            if Opened then
              begin
                Close(FDest);
                Erase(FDest)
              end;
            Exit
          end;
        if caly then
          begin
            Close(FSource);
            Break;
          end
      end;
    if full then CopyFile:=FlushBuffers
  until caly or not Valid
end;


{ TRecord }

{ Inicjacja obiektu zapamietujacego informacje o pojedynczym bloku }
{ w danym rodzaju pamieci.                                         }

Constructor TRecord.Init(ASize : Word; ACaly : Boolean; AAdres : Pointer;
  AUseMemory : TMem; const ASFileName, ADFileName : string);
begin
  inherited Init;
  Size:=ASize;
  Caly:=ACaly;
  Adres:=AAdres;
  UseMemory:=AUseMemory;
  SFileName:=NewStr(ASFileName);
  DFileName:=NewStr(ADFileName)
end;


{ Destrukcja obiektu. Jezeli istnieje mozliwosc to zwolnienie zajmowanej }
{ pamieci.                                                               }

Destructor TRecord.Done;
begin
  if SFileName<>nil then DisposeStr(SFileName);
  if DFileName<>nil then DisposeStr(DFileName);
  case UseMemory of
    umConv : FreeMem(Adres, Size);
    umUMB  : UMBFreeMem(Word(Adres));
  end;
  inherited Done
end;


{ TQCopyParams }

{ Obsluga danego parametru (podanego z linii polecen). }

Function TQCopyParams.Obsluz(parametr : string) : Boolean;

  Function SprawdzDate : Boolean;
  var
    sep  : Char;
    data : string [10];
    poz  : Integer;
    next : Integer;
    kod  : Integer;
  begin
    SprawdzDate:=False;
    next:=1;
    if parametr[3]=':' then
      begin
        data:=Copy(parametr, 4, 255);
        if Pos('\', data)>0 then sep:='\'
        else if Pos('.', data)>0 then sep:='.'
        else if Pos('-', data)>0 then sep:='-';
        poz:=Pos(sep, Copy(data, next, 255));
        Val(Copy(data, next, poz-1), Dzien, kod);
        if kod=0 then
          begin
            Inc(next, poz);
            poz:=Pos(sep, Copy(data, next, 255));
            Val(Copy(data, next, poz-1), Miesiac, kod);
            if kod=0 then
              begin
                Inc(next, poz);
                Val(Copy(data, next, 255), Rok, kod);
                if (kod=0) and (Dzien>=1) and (Dzien<=31) and (Miesiac>=1) and
                  (Miesiac<=12) and (Rok>=1980) and (Rok<=2099) then SprawdzDate:=True
              end
          end
      end
  end;

begin
  Obsluz:=True;
  if parametr='/A' then
    if M then
      begin
        WriteLn(#10#13'QCOPY: Parametry /A i /M nie mog wystpowa jednoczesnie.');
        Obsluz:=False
      end
     else
      A:=True
  else if parametr='/M' then
    if A then
      begin
        WriteLn(#10#13'QCOPY: Parametry /M i /A nie mog wystpowa jednoczesnie.');
        Obsluz:=False
      end
     else
      M:=True
  else if Copy(parametr, 1, 2)='/D' then
    if D then
      begin
        WriteLn(#10#13'QCOPY: Powtrzono parametr /D.');
        Obsluz:=False
      end
     else
      begin
        D:=SprawdzDate;
        Obsluz:=D;
        if not D then
          WriteLn(#10#13'QCOPY: Bdny format daty (uyj: DD-MM-RRRR).')
      end
  else if parametr='/P' then P:=True
  else if parametr='/S' then S:=True
  else if parametr='/E' then E:=True
  else if parametr='/-H' then _H:=True
  else if parametr='/V' then V:=True
  else if parametr='/W' then W:=True
  else if parametr='/Y' then _Y:=False
  else if parametr='/-Y' then _Y:=True
  else if parametr='/R' then R:=True
  else if parametr='/L' then L:=True
  else
    Obsluz:=inherited Obsluz(parametr)
end;


{ Wyswietlenie krotkiej pomocy. }

Procedure TQCopyParams.Pomoc;
const
  tekst : array [1..22] of PChar =
    ('',
     'Kopiowanie plikw wraz z caym drzewem podskorowidzow.',
     '',
     'QCOPY rodo [cel] [/A | /M] [/D:data] [/P] [/S] [/E] [/V] [/W] [/R] [/-H] [/L]',
     '  rodo     Specyfikacja plik(w) do kopiowania.',
     '  cel        Specyfikacja lokacji i/lub nowej nazwy plikw.',
     '  /A         Kopiowanie plikw z atrybutem "Archive",',
     '             nie zmienia atrybutu.',
     '  /M         Kopiowanie plikw z atrybutem "Archive",',
     '             kasuje atrybut "Archive".',
     '  /R         Przenoszenie plikw (kasowanie plikw zrodowych).',
     '  /D:data    Kopiowanie plikw zmienionych we wskazanym dniu lub pzniej.',
     '  /P         Pytanie przed tworzeniem kadego zbioru docelowego.',
     '  /S         Kopiowanie skorowidzow i podskorowidzow, jeeli te nie s puste.',
     '  /E         Kopiowanie kadego podskorowidza, nawet jeeli bdzie pusty.',
     '  /-H        Nie kopiowanie plikw ukrytych i systemowych.',
     '  /L         Doczenie zbiorw na koniec ju istniejcych plikw.',
     '  /V         Weryfikacja kadego nowego pliku.',
     '  /W         Pytanie o nacisnicie klawisza przed kopiowaniem.',
     '  /Y         Anulowania pytania o potwierdzenie przy zastpowaniu',
     '             istniejcego pliku docelowego.',
     '  /-Y        Zatwierdzenie pytania przy zastpowaniu istniejcego pliku.');
var
  i : Integer;
begin
  for i:=1 to 22 do WriteLn(StrPas(tekst[i]));
  Koniec:=True
end;


{ Przygotowanie do operacji kopiowania. Ustalenie poczatkowych wartosci. }

Procedure Kopiuj;
var
  FilesSrc, FilesDst  : FNameStr;
  CopyObject          : PCopy;
  Koniec, Ok          : Boolean;
  tmp                 : PathStr;
  tmp_file            : file;
  Time                : LongInt;
  UnPack              : DateTime;

  { Kopiowanie kolejnych podskorowidzow. }

  Procedure KopiujPodskorowidz(sciezka : PathStr);
  var
    zbior : SearchRec;
  begin
    if Koniec then Exit;
    with parametry do
      begin
        if S or E then
          begin
            FindFirst(GetDirName(sciezka)+'*.*', Directory, zbior);
            while (DosError=0) and not Koniec do
              begin
                if ((_H and (zbior.Attr and SysFile=0) and (zbior.Attr and
                  Hidden=0)) or not _H) and
                  (zbior.Attr and Directory=Directory) and
                  (zbior.name<>'.') and (zbior.Name<>'..') and
                  (E or (S and JestZbior(GetDirName(sciezka)+zbior.Name+'\*.*'))) then
                  KopiujPodskorowidz(GetDirName(sciezka)+zbior.Name+'\*.*');
                FindNext(zbior)
              end
          end;
        tmp:=GetDirName(GetDirName(FilesDst)+Copy(sciezka, Length(
          GetDirName(FilesSrc))+1, 255));
        if not CreateDirTree(tmp) then
          begin
            parametry.Blad('QCOPY: Utworzenie docelowego podsko'+
              'rowidza ('+tmp+')'#10#13'nie jest moliwe.');
            Koniec:=True
          end;
        FindFirst(sciezka, Files, zbior);
        while (DosError=0) and not Koniec do
          begin
            if ((_H and (zbior.Attr and SysFile=0) and (zbior.Attr and
              Hidden=0)) or not _H) and (((A or M) and (zbior.Attr and
              Archive<>0)) or (not A and not M)) then
              begin
                ok:=True;
                if D then
                  begin
                    Assign(tmp_file, GetDirName(sciezka)+zbior.Name);
                    FileMode:=0;
                    Reset(tmp_file);
                    FileMode:=2;
                    GetFTime(tmp_file, Time);
                    Close(tmp_file);
                    UnPackTime(Time, UnPack);
                    if (Rok>UnPack.Year) or ((Rok=UnPack.Year) and
                      (Miesiac>UnPack.Month)) or ((Rok=UnPack.Year) and
                      (Miesiac=UnPack.Month) and (Dzien>UnPack.Day)) then
                      ok:=False
                  end;
                if ok then
                  if not CopyObject^.CopyFile(GetDirName(sciezka)+zbior.Name,
                    tmp+ChangeName(GetFileName(FilesDst), zbior.Name)) then
                     Koniec:=True
              end;
            FindNext(zbior)
          end
      end
  end;

  Function Wait : Boolean;
  begin
    Wait:=True;
    if parametry.W then
      begin
      Write('Nacinij dowolny klawisz aby kontynuowa lub ESC aby przerwa operacj...');
        if ReadKey=#27 then
          Wait:=False
         else
          WriteLn;
        WriteLn
      end
  end;

  Function TestDestDir : Boolean;
  var
    wybor : Char;
  begin
    TestDestDir:=True;
    if (Pos('?', FilesDst)=0) and (Pos('*', FilesDst)=0) and
      not PathValid(FilesDst) then
      begin
        WriteLn('Czy "', GetFileName(FilesDst), '" oznacza nazw pliku,');
        WriteLn('czy te nazw skorowidza docelowego');
        Write('(P = plik, S = skorowidz)? ');
        repeat
          wybor:=UpCase(ReadKey)
        until wybor in ['P', 'S', #27];
        if wybor in ['P', 'S'] then WriteLn(wybor);
        case wybor of
          'S' : FilesDst:=FilesDst+'\*.*';
          'P' :
            with parametry do if not L and R and (Pos('?', FilesSrc)>0) or
              (Pos('*', FilesSrc)>0) then
              begin
                WriteLn;
                WriteLn('Ta operacja moe spowodowa utrat prawie '+
                  'wszystkich danych.');
                Write('Kontynuowa (T/N)? ');
                if UpCase(ReadKey)<>'T' then
                  begin
                    WriteLn('Nie');
                    TestDestDir:=False;
                    Write('Operacja anulowana.')
                  end
                 else
                  WriteLn('Tak')
              end;
          #27 :
            begin
              TestDestDir:=False;
              Write(' Operacja anulowana.')
            end
        end;
        WriteLn
      end
  end;

  Procedure SkorygujSciezki;
  begin
    FilesSrc:=parametry.plik1^;
    if PathValid(FilesSrc) then
      begin
        BackSlash(FilesSrc);
        FilesSrc:=FilesSrc+'*.*'
      end;
    if parametry.plik2<>nil then FilesDst:=parametry.plik2^ else GetDir(0, FilesDst);
    if PathValid(FilesDst) then
      begin
        BackSlash(FilesDst);
        FilesDst:=FilesDst+'*.*'
      end
  end;

begin
  SkorygujSciezki;

  if not FileExist(FilesSrc) then
    begin
      with parametry do Blad('QCOPY: cieka zrdowa ('+plik1^+') jest bdna.');
      kod_wyjscia:=1;
      Exit
    end;
  if (FilesSrc=FilesDst) and (parametry.plik2=nil) then
    begin
      parametry.Blad('QCOPY: Nie mona kopiowa danych do tego samego skorowidza.');
      kod_wyjscia:=4;
      Exit
    end;

  WriteLn;
  if not Wait or not TestDestDir then
    begin
      kod_wyjscia:=4;
      Exit
    end;
  WriteLn('Wczytuj zbiory...');
  with parametry do CopyObject:=New(PCopy, Init(M, P, V, _Y, R, L));
  Koniec:=False;
  KopiujPodskorowidz(FilesSrc);
  CopyObject^.Done;
  if (CopyObject^.Valid=False) and (kod_wyjscia=0) then kod_wyjscia:=3;

  if parametry.R then Write('  Przeniesiono ') else Write('  Skopiowano ');
  Write(CopyObject^.FilesCopied, ' plik');
  if CopyObject^.FilesCopied=1 then
    WriteLn('.')
   else
    if (CopyObject^.FilesCopied mod 100 in [0, 5..21]) or
      (CopyObject^.FilesCopied mod 10 in [0, 1, 5..9]) then
      WriteLn('w.')
     else
      WriteLn('i.');
  Dispose(CopyObject)
end;


var
  OldInt24h   : Pointer;
  OldExitProc : Pointer;


{ Procedura obslugi zakonczenia programu. }

Procedure KoniecProg; far;
begin
  ExitProc:=OldExitProc;
  SetIntVec($24, OldInt24h);
  if ErrorAddr<>nil then
    begin
      WriteLn('Wystpi niespodziewany bd podczas wykonywania programu. Przykro mi, lecz');
      WriteLn('nie jest moliwe przywrcenie funkcjonowania programu. Bd w dziaaniu');
      WriteLn('programu mg spowodowa zablokowanie blokw pamici.');
      Write(#10#13'Komunikat systemowy: ')
    end
   else
    ExitCode:=kod_wyjscia
end;


{ Procedura obslugi sytuacji wyjatkowej (m.in. blad na dysku). }

Procedure NewInt24h(Flags, CS, IP, AX, BX, CX, DX, SI, DI, DS, ES, BP: Word); interrupt;
var
  wybor : Char;
begin
  WriteLn;
  Write('Wystpi bd ');
  if AX and $8000=0 then
    begin
      if AX and $0100<>0 then Write('zapisu ') else Write('odczytu ');
      Write('w napdzie ', Chr(AX and $FF+Ord('A')), '. ');
      Write(IOResultCode(DI+19))
    end;
  WriteLn;
  Write('(A)nulowa czy (P)owtrzy?');
  repeat
    wybor:=UpCase(ReadKey);
    case wybor of
      'P' : AX:=1;
      'A' : AX:=3
    end
  until wybor in ['A', 'P'];
  WriteLn(wybor);
end;

begin
  kod_wyjscia:=0;
  WriteLn('QCOPY, (c) by Buk Mariusz, 1995'#10#13);
  Write('Dostpna pami: ');
  if IsXMS then Write('XMS (', XMSMemAvail div 1024, ') + ');
  if IsUMB then Write('UMB (', UMBMaxAvail div 1024, ') + ');
  WriteLn('konwencjonalna (', MemAvail div 1024, ') = ', (MemAvail+XMSMemAvail+
    UMBMaxAvail) div 1024, ' Kb');
  CheckBreak:=False;
  OldExitProc:=ExitProc;
  ExitProc:=@KoniecProg;
  GetIntVec($24, OldInt24h);
  SetIntVec($24, @NewInt24h);
  parametry.Init;
  if not parametry.Koniec then
    if (parametry.plik1<>nil) then
      Kopiuj
     else
      begin
        parametry.Blad('QCOPY: Nie podano adnych parametrw (sprbuj /?).');
        kod_wyjscia:=4
      end
   else
    kod_wyjscia:=4;
  parametry.Done
end.