{************************************************}
{*                                              *}
{* Nazwa modulu     :  Params                   *}
{* Wersja           :  2.00                     *}
{* Kompilowane w    :  Turbo Pascal ver. 7.0    *}
{* Procesor         :  8086 i lepszy            *}
{* Co-procesor      :  niepotrzebny             *}
{* Autor            :  Buk Mariusz              *}
{* Data             :  25 VII 1995              *}
{* Miejsce          :  Polska                   *}
{*                                              *}
{* Opis:                                        *}
{*                                              *}
{*   Modul PARAMS umozliwia bardzo proste       *}
{*   operowanie na parametrach wejsciowych      *}
{*   podanych w linii polecen. Zastosowano      *}
{*   tutaj programowanie zorientowane           *}
{*   obiektowo.                                 *}
{*                                              *}
{************************************************}

{$F+,X+,D-,O-}

Unit Params;

interface

uses Objects;

type

  { Obiekt analizujacy parametry wejsciowe.                 }
  { Obsluga maks. dwoch nazw plikow oraz reszty parametrow, }
  { poodzielanych znakiem '/'. Obsluge parametrow przez     }
  { uzytkownika uzyskuje sie pokrywajac metode OBSLUZ.      }

  PParametry = ^TParametry;
  TParametry = object (TObject)
    koniec       : Boolean;
    plik1, plik2 : PString;
    constructor Init;
    destructor Done; virtual;
    procedure AnalizujParametry;
    function Obsluz(parametr : string) : Boolean; virtual;
    procedure Pomoc; virtual;
    procedure Blad(komunikat : string); virtual;
  end;

implementation

uses DOS, Utils;

{ Inicjacja obiektu. }

Constructor TParametry.Init;
begin
  inherited Init;
  Koniec:=False;
  AnalizujParametry
end;


{ Zwolnienie pamieci dla zmiennych typu PSTRING. }

Destructor TParametry.Done;
begin
  if plik1<>nil then DisposeStr(plik1);
  if plik2<>nil then DisposeStr(plik2);
  inherited Done
end;


{ Analiza parametrow podanych w poleceniu wykonawczym przy uruchomieniu }
{ programu. Procedura ta umozliwia pobieranie parametrow napisanych     }
{ w dowolnej kolejnosci i w prawie dowolny sposob.                      }

Procedure TParametry.AnalizujParametry;

var
  licz : Integer;
  args : string;

  Function CzytajNazwe : string;
  var
    nazwa : string;
  begin
    nazwa:=args[licz];
    Inc(licz);
    while (licz<=Length(args)) and not (args[licz] in ['/', ' ']) do
      begin
        nazwa:=nazwa+args[licz];
        Inc(licz)
      end;
    CzytajNazwe:=UpStr(nazwa)
  end;

var
  par : string;
begin
  if ParamCount=0 then Exit;
  args:='';
  for licz:=1 to ParamCount do args:=args+ParamStr(licz)+' ';
  licz:=1;
  while (licz<=Length(args)) and not Koniec do
    begin
      if args[licz]=' ' then
        begin
          Inc(licz);
          Continue
        end;
      par:=CzytajNazwe;
      if par[1] in ['/', '-'] then
        begin
          if not Obsluz(par) then
            begin
              Blad('Bdny parametr w linii polece ('+par+').');
              Break
            end
        end
       else
        if plik1=nil then
          plik1:=NewStr(FExpand(par))
         else
          if plik2=nil then
            plik2:=NewStr(FExpand(par))
           else
            begin
              Blad('Zbyt duo parametrw ('+par+').');
              Break
            end
    end
end;


{ Obsluga danego parametru. }

Function TParametry.Obsluz(parametr : string) : Boolean;
begin
  Obsluz:=True;
  if (parametr='/?') or (parametr='/H') or (parametr='/HELP') then
    Pomoc
   else
    Obsluz:=False
end;


{ Wyswietlenie krotkiej pomocy. }

Procedure TParametry.Pomoc;
begin
end;

{ Wyswietlenie informacje o blednych danych. }

Procedure TParametry.Blad(komunikat : string);
begin
  WriteLn;
  WriteLn(#7, komunikat);
  WriteLn('Operacja przerwana.');
  Koniec:=True
end;

end.