{************************************************}
{*                                              *}
{* Nazwa modulu     :  IOError                  *}
{* Wersja           :  1.00                     *}
{* Kompilowane w    :  Turbo Pascal ver. 7.0    *}
{* Procesor         :  8086 i lepszy            *}
{* Co-procesor      :  niepotrzebny             *}
{* Autor            :  Buk Mariusz              *}
{* Data             :  25 VII 1995              *}
{* Miejsce          :  Polska                   *}
{*                                              *}
{* Opis:                                        *}
{*                                              *}
{*   Modul IOError ma za zadanie zwrocenie      *}
{*   kodu bledu DOS'a w postaci tekstowej.      *}
{*                                              *}
{************************************************}

{$F+,X+,D-,O-}

Unit IOError;

interface

function IOResultCode(nr : Integer) : string;

implementation

uses Utils;

Function IOResultCode(nr : Integer) : string;
var
  s : string;
begin
  case nr of
      0 : s:='Wszystko w porzdku.';
      1 : s:='Bdna funkcja.';
      2 : s:='Nie znaleziono pliku.';
      3 : s:='Nie znaleziono cieki.';
      4 : s:='Zbyt wiele otwartych plikw.';
      5 : s:='Brak dostpu.';
      6 : s:='Bdny uchwyt pliku.';
      7 : s:='Bdne struktura blokw pamici.';
      8 : s:='Zbyt mao pamici.';
      9 : s:='Bdny adres bloku pamici.';
     10 : s:='Bdne rodowisko.';
     11 : s:='Bdny format danych.';
     12 : s:='Bdny kod dostpu do pliku.';
     13 : s:='Bdne dane.';
     15 : s:='Bdny napd.';
     16 : s:='Nie mona usun biecego skorowidza.';
     17 : s:='Nie mona zmienia nazwy pliku przez zmian dysku.';
     18 : s:='Nie ma wicej plikw.';
     19 : s:='Proba zapisu na zabezpieczonym dysku.';
     20 : s:='Nieznana jednostka.';
     21 : s:='Napd dyskowy nie jest gotowy.';
     22 : s:='Nieznane polecenie.';
     23 : s:='Bd danych CRS.';
     24 : s:='Za dugo struktury danych polecenia.';
     25 : s:='Bd odszukania cieki na dysku.';
     26 : s:='Nieznany typ nonika.';
     27 : s:='Nie znaleziony sektor.';
     28 : s:='Brak papieru w drukarce.';
     29 : s:='Bd zapisu.';
     30 : s:='Bd odczytu.';
     31 : s:='Uszkodzenie oglne.';
    100 : s:='Bd odczytu.';
    101 : s:='Zbyt mao miejsca na dysku.';
    102 : s:='Plik nie zosta skojarzony.';
    103 : s:='Plik nie jest otwarty.';
    104 : s:='Plik nie jest otwarty do wprowadzania danych.';
    105 : s:='Plik nie jest otwarty do odczytywania danych.';
    106 : s:='Bdny format numeryczny.';
    150 : s:='Dysk jest zabezpieczony przed zapisem.';
    151 : s:='Bdny napd';
    152 : s:='Napd nie jest gotowy.';
    154 : s:='Bd sumy kontrolnej.';
    156 : s:='Bd podczas przeszukiwania dysku.';
    157 : s:='Nieznany typ urzdzenia.';
    158 : s:='Sektor nie zosta znaleziony.';
    159 : s:='W drukarce nie ma papieru.';
    160 : s:='Bd urzdzenia podczas zapisu.';
    161 : s:='Bd urzdzenia podczas odczytu.';
    162 : s:='Awaria sprztu.'
    else  s:='Niezidentyfikowany bd nr '+IntStr(nr)+'.'
  end;
  IOResultCode:=s
end;

end.