{$F+,X+,O-,V-,I-}

{****************************************************}
{*                                                  *}
{* Nazwa modulu        : Utils                      *}
{* Wersja              : 1.00                       *}
{* Kompilowane w       : Turbo Pascal ver. 6.0      *}
{* Procesor            : 80x86                      *}
{* Co-procesor         : niepotrzebny               *}
{* Autor               : Buk Mariusz                *}
{* Data                : 10 IX 1994                 *}
{* Miejsce             : Polska                     *}
{*                                                  *}
{* Opis:                                            *}
{*                                                  *}
{*   Modul posiada wiele narzedzi ulatwiajacych     *}
{* wspolprace z lancuchami znakowymi oraz           *}
{* z systemem operacyjnym MS-DOS.                   *}
{* Jezeli podczas kompilowania programu wykorzystu- *}
{* jacego ten modul zostanie zasygnalizowany blad   *}
{* (type mismatch) to nalezy zdeaktywowac opcje     *}
{* kompilatora 'strict var-strings' ($V-).          *}
{*                                                  *}
{****************************************************}

Unit Utils;

interface

uses Dos;

const

  SP      = #32;
  LF      = #10;
  CR      = #13;
  NL      = CR+LF;
  NullStr = '';
  Bell    = #7;
  Files   = Archive+SysFile+Hidden+ReadOnly;

const

  DefaultSetOfChars = [ 'A'..'Z', 'a'..'z', '0'..'9', '_'];
  SetOfChars : set of Char = DefaultSetOfChars;


{ Funkcje do obrobki lancuchow. }

function LoCase(Ch : Char) : Char;
function LoStr(S : string) : string;
function UpStr(S : string) : string;
function BlankStr(n : Byte) : string;
function NLStr(n : Byte) : string;
function LeftStr(S : string; n : Byte) : string;
function RightStr(S : string; n : Byte) : string;
function CharStr(ch : Char; n : Byte) : string;
function CenterStr(S : string; n : Byte) : string;
function ClearSpaces(S : string) : string;
function GetWord(S : string; nr : Integer) : string;


{ Funkcje formatujace tekst daty i godziny. }

function TimeStr : string;
function DateStr : string;


{ Funkcje do konwersji liczb w dane tekstowe. }

function IntStr(n : LongInt) : string;
function RealStr(x : Real; n : Integer) : string;
function DigitStr(n : LongInt; width : Byte) : string;


{ Funkcje i procedury pomocnicze obslugi zbiorow dyskowych. }

function CreateDirTree(path : PathStr) : Boolean;
function WhereIs(FileName : PathStr) : DirStr;
function PackPath(path : PathStr; len : Byte) : string;
function ChangeName(mask, name : string) : string;
procedure BackSlash(var path : string);
procedure ClearBackSlash(var path : string);
function GetDirName(S : PathStr) : DirStr;
function GetFileName(S : PathStr) : string;
function PathValid(Dir : DirStr) : Boolean;
function FileExist(Path : PathStr) : Boolean;
function FilesCount(Path : PathStr; Attr : Word) : Integer;
procedure CompletePath(var PathDest : string; PathSrc : string);


{ Funkcje stwierdzajace istnienie danej z konkretnego zakresu. }

function IsDigit(ch : Char) : Boolean;
function IsLetter(ch : Char) : Boolean;


{ Funkcje do konwersji liczb o dowolnej podstawie. }

function Any2Dec(S : string; Base : Byte; var ErrPos : Integer) : LongInt;
function Dec2Any(n : LongInt; Base : Byte) : string;
function Convert(S : string; BaseSource, BaseDest : Byte;
  var ErrPos : Integer) : string;


implementation


{ Zamiana duzej litery na mala. }

Function LoCase(Ch : Char) : Char; assembler;
asm
        mov     al, byte ptr [&Ch]
        cmp     al, 'A'
        jb      @koniec
        cmp     al, 'Z'
        ja      @koniec
        add     al, 'a'-'A'
@koniec:
end;


{ Zamiana duzych liter w lancuchu do malych. }

Function LoStr(S : string) : string;
var
  i : Byte;
begin
  for i:=1 to Length(S) do S[i]:=LoCase(S[i]);
  LoStr:=S
end;


{ Zamiana malych liter w lancuchu do duzych. }

Function UpStr(S : string) : string;
var
  i : Integer;
begin
  for i:=1 to Length(S) do S[i]:=UpCase(S[i]);
  UpStr:=S
end;


{ Podanie lancucha skladajacego sie z N spacji. }

Function BlankStr(n : Byte) : string;
begin
  BlankStr:=CharStr(SP, n)
end;


{ Podanie lancucha skladajacego sie z N kodow NL (next line). }

Function NLStr(n : Byte) : string;
begin
  NLStr:=CR+CharStr(LF, n)
end;


{ Konwersja liczby calkowitej do tekstu z uzupelnieniem zerami. }

Function DigitStr(n : LongInt; width : Byte) : string;
var
  S    : string;
  size : Byte absolute S;
begin
  Str(n, S);
  if n>=0 then
    begin
      if size>width then size:=width
       else
         if size<width then S:=CharStr('0', width-size)+S
    end;
  DigitStr:=S
end;


{ Justowanie lancucha do prawej strony. }

Function RightStr(S : string; n : Byte) : string;
var
  size : Byte absolute S;
begin
  if size>n then
    size:=n
   else
    if size<n then Insert(BlankStr(n-size), S, 1);
  RightStr:=S
end;


{ Justowanie lancucha do lewej strony. }

Function LeftStr(S : string; n : Byte) : string;
var
  size : Byte absolute S;
begin
  if size>n then
    size:=n
   else
    if size<n then for size:=size+1 to n do S[size]:=Sp;
  LeftStr:=S
end;


{ Podanie lancucha skladajacego sie z N znakow CH. }

Function CharStr(ch : Char; n : Byte) : string;
var
  S    : string;
  size : Byte absolute S;
begin
  if n=0 then
    S:=NullStr
   else
    for size:=1 to n do S[size]:=ch;
  CharStr:=S
end;


{ Centrowanie lanucha. }

Function CenterStr(S : string; n : Byte) : string;
var
  size : Byte absolute S;
  lm   : Byte;
begin
  if size<n then
    begin
      lm:=(n-size) div 2;
      S:=LeftStr((BlankStr(lm)+S), n)
    end
   else
    if size>n then size:=n;
  CenterStr:=S
end;


{ Usuniecie spacji z tekstu. }

Function ClearSpaces(S : string) : string;
var
  s1 : string;
  i  : Byte;
begin
  s1:=NullStr;
  for i:=1 to Length(S) do
    if (s[i]<>SP) and (s[i]<>#9) then s1:=s1+s[i];
  ClearSpaces:=s1
end;


{ Wyciagniecie z lancucha slowa o danym numerze. }

Function GetWord(S : string; nr : Integer) : string;
var
  i    : Byte;
  pocz : Byte;
  stan : Boolean;
  pom  : string;
begin
  GetWord:='';
  if nr<=0 then Exit;
  i:=1; pocz:=0; stan:=False; pom:='';
  while i<=Length(s) do
    begin
      if UpCase(s[i]) in SetOfChars then
        begin
          if not stan then
            begin
              pocz:=i;
              stan:=not stan
            end
        end
       else
        if stan then
          begin
            Dec(nr);
            if nr=0 then
              begin
                pom:=Copy(s, pocz, i-pocz);
                Break
              end
             else
              stan:=not stan
          end;
      Inc(i)
    end;
  if stan and (pom='') and (nr=1) then
    pom:=Copy(s, pocz, 255);
  GetWord:=pom
end;


{ Podanie lancuchowej postaci czasu. }

Function TimeStr : string;
var
  Hour, Minute, Second, Sec100 : Word;
begin
  GetTime(Hour, Minute, Second, Sec100);
  TimeStr:=DigitStr(Hour, 2)+':'+DigitStr(Minute, 2)+'.'+DigitStr(Second, 2)
end;


{ Podanie lancuchowej postaci daty. }

Function DateStr : string;
const
  dni : array [0..6] of String[12] =
    ('Niedziela', 'Poniedzialek', 'Wtorek', 'Sroda', 'Czwartek',
     'Piatek', 'Sobota');
  miesiace  : array [1..12] of String[12] =
    ('stycznia', 'lutego', 'marca', 'kwietnia', 'maja', 'czerwca',
     'lipca', 'sierpnia', 'wrzesnia', 'pazdziernika', 'listopada',
     'grudnia');
var
  Year, Month, Day, DayNum : Word;
begin
  GetDate(Year, Month, Day, DayNum);
  DateStr:=dni[DayNum]+', '+IntStr(Day)+Sp+miesiace[Month]+Sp+IntStr(Year)
end;


{ Konwersja liczby calkowitej do tekstu. }

Function IntStr(n : LongInt) : string;
var
  S : string;
begin
  Str(n, S);
  IntStr:=S
end;


{ Konwersja liczby rzeczywistej do tekstu. }

Function RealStr(x : Real; n : Integer) : string;
var
  S : string;
begin
  Str(x:0:n, S);
  RealStr:=S
end;


{ Utworzenie drzewa podskorowidzow. }

Function CreateDirTree(path : PathStr) : Boolean;
var
  w : Boolean;
begin
  if not PathValid(path) then
    begin
      ClearBackSlash(path);
      w:=CreateDirTree(GetDirName(path));
      CreateDirTree:=w;
      if w then MkDir(path)
    end
   else
    CreateDirTree:=True
end;


{ Pobranie skorowidza w ktorym znajduje sie plik o nazwie FileName. }

Function WhereIs(FileName : PathStr) : DirStr;
begin
  WhereIs:=NullStr;
  FileName:=FExpand(FSearch(FileName, GetEnv('PATH')));
  if GetFileName(FileName)<>NullStr then
    WhereIs:=Copy(GetDirName(FileName), 1, Length(FileName)-1)
end;


{ Upakowanie sciezki. }

Function PackPath(path : PathStr; len : Byte) : string;
begin
  if len<7 then
    PackPath:=Copy(path, 1, len)
   else
    if len<Length(path) then
      PackPath:=Copy(path, 1, 3)+'...'+Copy(path, Length(path)-len+7, 255)
     else
      PackPath:=path
end;


{ Uzupelnienie nazwy pliku. }

Function ChangeName(mask, name : string) : string;

  Function SubChangeName(ex1, ex2 : string) : string;
  var
    i   : Byte;
    pom : string;
  begin
    pom:=NullStr;
    for i:=1 to Length(ex1) do
      if ex1[i]='?' then
        pom:=pom+ex2[i]
       else
        if ex1[i]='*' then
          begin
            SubChangeName:=pom+Copy(ex2, i, 255);
            Exit
          end
         else
          pom:=pom+ex1[i];
    SubChangeName:=pom
  end;

var
  d     : DirStr;
  n, n1 : NameStr;
  e, e1 : ExtStr;
begin
  FSplit(name, d, n1, e1);
  FSplit(mask, d, n, e);
  ChangeName:=d+SubChangeName(n, n1)+SubChangeName(e, e1)
end;


{ Dodanie znaku '\', jesli jest to mozliwe. }

Procedure BackSlash(var path : string);
var
  len : Byte absolute path;
begin
  if ((Len<>2) or ((Len=2) and (path[2]<>':'))) and (path<>NullStr) then
    if path[Len]<>'\' then path:=path+'\'
end;


{ Usunicie znaku '\', jesli jest to mozliwe. }

Procedure ClearBackSlash(var path : string);
var
  len : Byte absolute path;
begin
  if not ((Len=3) and (path[2]=':') and (path[3]='\')) and (path<>NullStr) then
    if path[Len]='\' then Dec(path[0])
end;


{ Pobranie nazwy skorowidza z lancucha S. }

Function GetDirName(S : PathStr) : DirStr;
var
  Dir  : DirStr;
  Name : NameStr;
  Ext  : ExtStr;
begin
  FSplit(S, Dir, Name, Ext);
  GetDirName:=Dir
end;


{ Pobranie nazwy zbioru z lancucha S. }

Function GetFileName(S : PathStr) : string;
var
  Dir  : DirStr;
  Name : NameStr;
  Ext  : ExtStr;
begin
  FSplit(S, Dir, Name, Ext);
  GetFileName:=Name+Ext
end;


{ Stwierdzenie poprawnosci sciezki Path. }

Function PathValid(Dir : DirStr) : Boolean;
var
  OldD : DirStr;
begin
  GetDir(0, OldD);
  ClearBackSlash(Dir);
  ChDir(Dir);
  PathValid:=IOResult=0;
  ChDir(OldD)
end;


{ Stwierdzenie istnienia zbioru. }

Function FileExist(Path : PathStr) : Boolean;
var
  zbior : SearchRec;
begin
  FindFirst(Path, Files, zbior);
  FileExist:=DosError=0
end;


{ Pobranie ilosci zbiorow wg sciezki i atrybutow. }

Function FilesCount(Path : PathStr; Attr : Word) : Integer;
var
  zbior : SearchRec;
  ile   : Integer;
begin
  ile:=0;
  FindFirst(Path, Attr, zbior);
  while DosError=0 do
    begin
      if zbior.Attr and Attr<>0 then Inc(ile);
      FindNext(zbior)
    end;
  FilesCount:=ile
end;


{ Uzupelnienie sciezki. }

Procedure CompletePath(var PathDest : string; PathSrc : string);
var
  Dir, d  : DirStr;
  Name, n : NameStr;
  Ext, e  : ExtStr;
begin
  FSplit(PathSrc, d, n, e);
  FSplit(PathDest, Dir, Name, Ext);
  if Dir  = NullStr then Dir  := d;
  if Name = NullStr then Name := n;
  if Ext  = NullStr then Ext  := e;
  PathDest:=Dir+Name+Ext
end;


{ Stwierdzenie cyfry. }

Function IsDigit(ch : Char) : Boolean;
begin
  IsDigit:=('0'<=ch) and (ch<='9')
end;


{ Stwierdzenie litery. }

Function IsLetter(ch : Char) : Boolean;
begin
  ch:=UpCase(ch);
  IsLetter:=('A'<=ch) and (ch<='Z')
end;


{ Konwersja tekstu zawierajacego wartosc o podstawie danej w BASE }
{ (z uwzglednieniem bledu) do liczby dziesietnej, zwracanej jako  }
{ wynik.                                                          }

Function Any2Dec(S : string; Base : Byte; var ErrPos : Integer) : LongInt;
var
  i, d : Byte;
  x    : LongInt;
begin
  ErrPos:=0;
  x:=0;
  if Length(S)<1 then
    ErrPos:=-1
   else
    for i:=1 to Length(S) do
      begin
        d:=Byte(UpCase(S[i]))-48;
        if d>9 then Dec(d, 7);
        if (d>=Base) or (Base*x+d<x) then
          begin
            ErrPos:=i;
            Break
          end;
        x:=Base*x+d
      end;
  Any2Dec:=x
end;


{ Konwersja wartosci dziesietnej do wartosci danej podstawa BASE. }

Function Dec2Any(n : LongInt; Base : Byte) : string;
var
  y, x : LongInt;
  d, i : Byte;
  S    : string;
begin
  S:=CharStr('0', 255);
  i:=255; x:=n;
  repeat
    y:=x div Base;
    d:=x-Base*y;
    S[i]:=Chr(d+48+7*Byte(d>9));
    x:=y;
    Dec(i)
  until x=0;
  Dec2Any:=Copy(S, i+1, 255)
end;


{ Konwersja wartosci danej podstawa BASESOURCE do wartosci o podstawie }
{ BASEDEST.                                                            }

function Convert(S : string; BaseSource, BaseDest : Byte;
  var ErrPos : Integer) : string;
begin
  Convert:=Dec2Any(Any2Dec(S, BaseSource, ErrPos), BaseDest)
end;

end.