{*********************************************************}
{*                                                       *}
{* Nazwa modulu  :     Mouse                             *}
{* Wersja        :     1.10                              *}
{* Kompilowane w :     Turbo Pascal ver. 7.0             *}
{* Procesor      :     80x86                             *}
{* Co-procesor   :     niepotrzebny                      *}
{* Autor         :     Buk Mariusz                       *}
{* Data          :     14 I 1995                         *}
{* Miejsce       :     Polska                            *}
{*                                                       *}
{* Opis:                                                 *}
{*                                                       *}
{*   Modul umozliwia proste korzystanie z myszki         *}
{*   kompatybilnej z Microsoft.                          *}
{*                                                       *}
{*********************************************************}

{$F+,D-,O-,X+}

Unit Mouse;

interface

uses Objects;


type

  { Typ MouseButtonInfo sluzy do przechowywania informacji o stanie myszki, }
  { ilosci nacisniec klawisza myszki oraz starej pozycji myszki.            }

  MouseButtonInfo = record
    State      : Boolean;
    Count      : Word;
    OldX, OldY : Word;
  end;


  { Typ DriverInfo pozwala na przechowywanie informacji o myszce, takich }
  { jak: wersja sterownika, typ myszki, obslugiwane przerwanie, typ ste- }
  { rownika, typ kursora.                                                }

  DriverInfo = record
    Version    : Word;
    IRQ        : Byte;
    MouseType  : Byte;
    DriverType : Byte;
    CursorType : Byte;
  end;


  { Typ Mask sluzy do przechowywania maski kursora i ekranu (przy zmianie }
  { standardowego kursora).                                               }

  Mask = array [1..2] of array [1..16] of Word;


type

  { Typ obiektowy TOneView sluzy do przechowywaniu informacji o jednym }
  { obiekcie, ktory nastepnie moze byc przegladany przy poszukiwaniu   }
  { obiektow na ekranie.                                               }

  POneView = ^TOneView;
  TOneView = object (TObject)
    A, B : TPoint;
    Id   : Word;
    constructor Init(x1, y1, x2, y2 : Integer; AId : Word);
    constructor Load(var S : TStream);
    procedure Store(var S : TStream); virtual;
    procedure Move(ADX, ADY : Integer);
    function Contains(x, y : Integer) : Boolean;
  end;


function InitMouse : Boolean;
procedure MouseUnitDone;
function MouseButtons : Word;
procedure ShowMouse;
procedure HideMouse;
function GetMouseStatus(var X, Y : Integer) : Word;
function WhereMX : Integer;
function WhereMY : Integer;
function Button : Byte;
procedure SetMousePos(X, Y : Word);
procedure ButtonPressed(no : Word; var buffer : MouseButtonInfo);
procedure ButtonReleased(no : Word; var buffer : MouseButtonInfo);
procedure SetMinMaxHorizPos(Min, Max : Integer);
procedure SetMinMaxVertPos(Min, Max : Integer);
procedure SetGraphCursor(Xcenter, Ycenter : Integer; var MaskCursor : Mask);
procedure SetTextCursor(which : Byte; arg1, arg2 : Word);
procedure LightPenEmulOn;
procedure LightPenEmulOff;
procedure SetMouseTrap(MinX, MinY, MaxX, MaxY : Word);
function SaveDriverState : Boolean;
function RestoreDriverState : Boolean;
procedure SetSensitive(dX, dY : Byte);
procedure GetSensitive(var dX, dY : Byte);
procedure SetScreenPage(no : Byte);
function GetScreenPage : Byte;
function DisableMouse : Boolean;
procedure EnableMouse;
procedure GetDriverInfo(var buffer : DriverInfo);
procedure GetTextCursor(var arg1, arg2 : Word);
function IsMouseVisible : Boolean;

function Search(objects : PCollection; x, y : Integer) : POneView;
procedure RegisterMouse;


const

  { Stale PRESS i RELEASE oznaczaja kolejno: nacisniecie i zwolnienie }
  { przycisku myszki.                                                 }

  Press   = True;
  Release = False;


  { Stala korekcji wspolrzednych ekranowych. }

  Correction : Boolean = False;


  { Literal rejestracyjny dla obiektu TOneView. }

  ROneView : TStreamRec = (
    ObjType : 65500;
    VMTLink : Ofs(TypeOf(TOneView)^);
    Load    : @TOneView.Load;
    Store   : @TOneView.Store);


implementation

var
  DataBuffer : Pointer; { wskaznik na bufor przy przechowywaniu stanu myszki }
  Size       : Word;    { wielkosc bufora                                    }


{ Wewnetrzna procedura modulu. Modyfikacja wspolrzednych w zaleznosci od  }
{ panujacego trybu graficznego. Zmiana na wspolrzedne ekranowe.           }
{ Wejscie:                                                                }
{   CX - wspolrzedna pozioma                                              }
{   DX - wspolrzedna pionowa                                              }
{ Wyjscie:                                                                }
{   CX - przeksztalcona wspolrzedna pozioma                               }
{   DX - przeksztalcona wspolrzedna pionowa                               }


Procedure KorektaDoEkranu; near; assembler;
asm
   CMP   [Correction], 01
   JNE   @dalej
   PUSH AX
   PUSH BX
   MOV  AH, 0Fh
   INT  10h
   CMP  AL, 01h         { tryby 0..1 }
   JA   @d1
   SHR  CX, 01h
   SHR  CX, 01h
   SHR  CX, 01h
   SHR  CX, 01h
   SHR  DX, 01h
   SHR  DX, 01h
   SHR  DX, 01h         { 16x8 }
   JMP  @koniec
@d1:
   CMP  AL, 07h         { tryby 2..3, 7 }
   JE   @ok1
   CMP  AL, 03h
   JA   @d2
@ok1:
   MOV  AX, CX
   MOV  CL, 03h
   SHR  AX, CL
   SHR  DX, CL
   MOV  CX, AX          { 8x8 }
   JMP  @koniec
@d2:
   CMP  AL, 0Dh         { tryby 4..5, $0D, $13 }
   JE   @ok2
   CMP  AL, 13h
   JE   @ok2
   CMP  AL, 05h
   JA   @koniec
@ok2:
   SHR  CX, 01h         { 2x1 }
@koniec:                { pozostale tryby } { 1x1 }
   POP  BX
   POP  AX
@dalej:
end;


{ Wewnetrzna procedura modulu. Modyfikacja wspolrzednych w zaleznosci od  }
{ panujacego trybu graficznego. Zmiana na wspolrzedne sterownika myszki.  }
{ Wejscie:                                                                }
{   CX - wspolrzedna pozioma                                              }
{   DX - wspolrzedna pionowa                                              }
{ Wyjscie:                                                                }
{   CX - przeksztalcona wspolrzedna pozioma                               }
{   DX - przeksztalcona wspolrzedna pionowa                               }


Procedure KorektaDoSterownika; near; assembler;
asm
   CMP   [Correction], 01
   JNE   @dalej
   PUSH AX
   PUSH BX
   MOV  AH, 0Fh
   INT  10h
   CMP  AL, 01h         { tryby 0..1 }
   JA   @d1
   SHL  CX, 01h
   SHL  CX, 01h
   SHL  CX, 01h
   SHL  CX, 01h
   SHL  DX, 01h
   SHL  DX, 01h
   SHL  DX, 01h         { 16x8 }
   JMP  @koniec
@d1:
   CMP  AL, 07h         { tryby 2..3, 7 }
   JE   @ok1
   CMP  AL, 03h
   JA   @d2
@ok1:
   MOV  AX, CX
   MOV  CL, 03h
   SHL  AX, CL
   SHL  DX, CL
   MOV  CX, AX          { 8x8 }
   JMP  @koniec
@d2:
   CMP  AL, 0Dh         { tryby 4..5, $0D, $13 }
   JE   @ok2
   CMP  AL, 13h
   JE   @ok2
   CMP  AL, 05h
   JA   @koniec
@ok2:
   SHL  CX, 01h         { 2x1 }
@koniec:                { pozostale tryby } { 1x1 }
   POP  BX
   POP  AX
@dalej:
end;


{ TOneView }


{ Konstruktor typu TOneView inicjuje pola jednego prostokatnego obiektu. }

Constructor TOneView.Init(x1, y1, x2, y2 : Integer; AId : Word);
begin
  inherited Init;
  A.X:=x1; A.Y:=y1;
  B.X:=x2; B.Y:=y2;
  Id:=AId
end;


{ Konstruktor Load jest wykorzystywany przy inicjowania obiektu podczas }
{ odczytywania go ze strumienia.                                        }

Constructor TOneView.Load(var S : TStream);
begin
  S.Read(A, SizeOf(A));
  S.Read(B, SizeOf(B));
  S.Read(Id, SizeOf(Id))
end;


{ Procedura Store sluzy do zapamietania obiektu w strumieniu. }

Procedure TOneView.Store(var S : TStream);
begin
  S.Write(A, SizeOf(A));
  S.Write(B, SizeOf(B));
  S.Write(Id, SizeOf(Id))
end;


{ Procedura MOVE przesuwa (logicznie) obiekt o wektor <ADX, ADY>. }

Procedure TOneView.Move(ADX, ADY : Integer);
begin
  A.X:=A.X+ADX; B.X:=B.X+ADX;
  A.Y:=A.Y+ADY; B.Y:=B.Y+ADY
end;


{ Funkcja CONTAINS sprawdza czy punkt o wspolrzednych <x, y> znajduje sie }
{ w obiekcie.                                                             }

Function TOneView.Contains(x, y : Integer) : Boolean;
begin
  Contains:=(x>=A.X) and (x<=B.X) and (y>=A.Y) and (y<=B.Y)
end;


{ Zarejestrowanie typu TOneView w celu pozniejszych operacji odczytu/zapisu. }

Procedure RegisterMouse;
begin
  RegisterType(ROneView)
end;


{ Funkcja Search sprawdza cala kolekcje, az spotka punkt, ktory    }
{ znajduje sie w jednym z obiektow. Nastepnie zwraca adres obiektu }
{ znajdujacego sie w kolekcji.                                     }

Function Search(objects : PCollection; x, y : Integer) : POneView;

  Function Sprawdz(P : Pointer) : Boolean;
  begin
    if P<>nil then Sprawdz:=POneView(P)^.Contains(x, y)
  end;

begin
  Search:=nil;
  if objects<>nil then Search:=objects^.FirstThat(@Sprawdz)
end;


{ Inicjacja programowa myszy. Sprawdzenie istnienia ster. myszy w systemie. }

Function InitMouse : Boolean; assembler;
asm
   XOR  AX, AX
   INT  33h
end;


{ Pobranie ilosci przyciskow myszy. }

Function MouseButtons : Word; assembler;
asm
   XOR  AX, AX
   INT  33h
   MOV  AX, BX
end;


{ Uaktywnienie wyswietlania myszy. }

Procedure ShowMouse; assembler;
asm
   MOV   AX, 01h
   INT   33h
end;


{ Ukrycie myszy. }

Procedure HideMouse; assembler;
asm
   MOV   AX, 02h
   INT   33h
end;


{ Pobranie aktualnego stanu myszy. }

Function GetMouseStatus(var X, Y : Integer) : Word; assembler;
asm
   MOV   AX, 03h
   INT   33h
   MOV   AX, BX
   CMP   AX, 04h
   JNE   @dalej
   DEC   AX
@dalej:
   CALL  KorektaDoEkranu
   LES   BX, [y]
   MOV   ES:[BX], DX
   LES   BX, [x]
   MOV   ES:[BX], CX
end;


{ Pobranie pozycji X myszy. }

Function WhereMX : Integer; assembler;
asm
   MOV   AX, 03h
   INT   33h
   CALL  KorektaDoEkranu
   MOV   AX, CX
end;


{ Pobranie pozycji Y myszy. }

Function WhereMY : Integer; assembler;
asm
   MOV   AX, 03h
   INT   33h
   CALL  KorektaDoEkranu
   MOV   AX, DX
end;


{ Sprawdzenie nacisniecia klawiszy myszki. }

Function Button : Byte; assembler;
asm
   MOV   AX, 03h
   INT   33h
   MOV   AX, BX
   CMP   AX, 04h
   JNE   @dalej
   DEC   AX
@dalej:
end;


{ Ustawienie kursora myszy w danej pozycji. }

Procedure SetMousePos(X, Y : Word); assembler;
asm
   MOV   AX, 04h
   MOV   CX, [x]
   MOV   DX, [y]
   CALL  KorektaDoSterownika
   INT   33h
end;


{ Pobranie informacji o nacisnieciu przyciskow. }

Procedure ButtonPressed(no : Word; var buffer : MouseButtonInfo); assembler;
asm
   MOV  AX, 05h
   MOV  BX, [no]
   INT  33h
   LES  SI, [buffer]
   CMP  [no], 03h
   JNE  @d1
   INC  [no]
@d1:
   CMP  AX, [no]
   MOV  AH, 00h
   JNE  @d2
   INC  AH
@d2:
   MOV  byte ptr ES:[SI], AH
   MOV  word ptr ES:[SI+1], BX
   CALL KorektaDoEkranu
   MOV  word ptr ES:[SI+3], CX
   MOV  word ptr ES:[SI+5], DX
end;


{ Pobranie informacji o zwolnieniu przyciskow. }

Procedure ButtonReleased(no : Word; var buffer : MouseButtonInfo); assembler;
asm
   MOV  AX, 06h
   MOV  BX, [no]
   INT  33h
   LES  SI, [buffer]
   CMP  [no], 03h
   JNE  @d1
   INC  [no]
@d1:
   CMP  AX, [no]
   MOV  AH, 00h
   JE   @d2
   INC  AH
@d2:
   MOV  byte ptr ES:[SI], AH
   MOV  word ptr ES:[SI+1], BX
   CALL KorektaDoEkranu
   MOV  word ptr ES:[SI+3], CX
   MOV  word ptr ES:[SI+5], DX
end;


{ Ustalenie minimalnej i maksymalnej wspolrzednej poziomej kursora. }

Procedure SetMinMaxHorizPos(Min, Max : Integer); assembler;
asm
   MOV  AX, 07h
   MOV  CX, [min]
   CALL KorektaDoSterownika
   PUSH CX
   MOV  CX, [max]
   CALL KorektaDoSterownika
   MOV  DX, CX
   POP  CX
   INT  33h
end;


{ Ustalenie minimalnej i maksymalnej wspolrzednej pionowej kursora. }

Procedure SetMinMaxVertPos(Min, Max : Integer); assembler;
asm
   MOV  AX, 08h
   MOV  DX, [min]
   CALL KorektaDoSterownika
   PUSH DX
   MOV  DX, [max]
   CALL KorektaDoSterownika
   POP  CX
   INT  33h
end;


{ Ustalenie ksztaltu kursora graficznego. }

Procedure SetGraphCursor(Xcenter, Ycenter : Integer; var MaskCursor : Mask);
  assembler;
asm
   LES  DX, [MaskCursor]
   MOV  BX, [xcenter]
   MOV  CX, [ycenter]
   MOV  AX, 09h
   INT  33h
end;


{ Ustalenie rodzaju kursora tekstowego. }

Procedure SetTextCursor(which : Byte; arg1, arg2 : Word); assembler;
asm
   MOV  AX, 0Ah
   MOV  BH, AH
   MOV  BL, [which]
   MOV  CX, [arg1]
   MOV  DX, [arg2]
   INT  33h
end;


{ Wlaczenie emulacji piora swietlnego. }

Procedure LightPenEmulOn; assembler;
asm
  MOV   AX, 0Dh
  INT   33h
end;


{ Wylaczenie emulacji piora swietlnego. }

Procedure LightPenEmulOff; assembler;
asm
  MOV   AX, 0Eh
  INT   33h
end;


{ Ustawienie pulapki na kursor myszy. }

Procedure SetMouseTrap(MinX, MinY, MaxX, MaxY : Word); assembler;
asm
   MOV  AX, 10h
   MOV  CX, [maxx]
   MOV  DX, [maxy]
   CALL KorektaDoSterownika
   MOV  SI, CX
   MOV  DI, DX
   MOV  CX, [minx]
   MOV  DX, [miny]
   CALL KorektaDoSterownika
   INT  33h
end;


{ Zapamietanie stanu programu obslugi myszy. }

Function SaveDriverState : Boolean;
begin
  if DataBuffer<>nil then
    begin
      FreeMem(DataBuffer, Size);
      DataBuffer:=nil
    end;
  asm
     MOV  AX, 15h
     INT  33h
     MOV  [Size], BX
  end;
  GetMem(DataBuffer, Size);
  if DataBuffer<>nil then
    asm
       LES  DX, DataBuffer
       MOV  AX, 16h
       INT  33h
       MOV  AL, 01h
    end
   else
    asm
       XOR  AL, AL
    end
end;


{ Odtworzenie stanu programu obslugi myszy. }

Function RestoreDriverState : Boolean;
begin
  if DataBuffer<>nil then
    asm
      LES  DX, DataBuffer
      MOV  AX, 17h
      INT  33h
      MOV  AL, 01h
    end
   else
    asm
      XOR  AL, AL
    end
end;


{ Ustalenie czulosci myszy. }

Procedure SetSensitive(dX, dY : Byte); assembler;
asm
   MOV  AX, 1Ah
   XOR  BH, BH
   XOR  CH, CH
   XOR  DX, DX
   MOV  BL, [&dx]
   MOV  CL, [dy]
   INT  33h
end;


{ Pobranie czulosci myszy. }

Procedure GetSensitive(var dX, dY : Byte); assembler;
asm
   MOV  AX, 1Bh
   INT  33h
   LES  SI, [&dX]
   MOV  byte ptr ES:[SI], BL
   LES  SI, [dY]
   MOV  byte ptr ES:[SI], CL
end;


{ Ustalenie strony ekranu. }

Procedure SetScreenPage(no : Byte); assembler;
asm
   MOV  AX, 1Dh
   XOR  BH, BH
   MOV  BL, [no]
   INT  33h
end;


{ Pobranie strony ekranu. }

Function GetScreenPage : Byte; assembler;
asm
   MOV  AX, 1Eh
   INT  33h
   MOV  AX, BX
end;


{ Wylaczenie programu obslugi myszy. }

Function DisableMouse : Boolean; assembler;
asm
   MOV  AX, 1Fh
   INT  33h
   INC  AX
   AND  AX, AX
   JZ   @dalej
   MOV  AL, 01h
   @dalej:
end;


{ Uaktywnienie programu obslugi myszy. }

Procedure EnableMouse; assembler;
asm
   MOV  AX, 20h
   INT  33h
end;


{ Pobranie informacji od sterownika myszy. }

Procedure GetDriverInfo(var buffer : DriverInfo); assembler;
asm
   MOV  AX, 24h
   INT  33h
   LES  SI, [buffer]
   MOV  word ptr ES:[SI], BX
   MOV  word ptr ES:[SI+2], CX
   MOV  AX, 25h
   INT  33h
   TEST AX, 8000h
   XOR  CL, CL
   JZ   @d1
   INC  CL
   @d1:
   MOV  byte ptr ES:[SI+4], CL
   MOV  CL, 12d
   SHR  AX, CL
   AND  AL, 03h
   MOV  byte ptr ES:[SI+5], AL
end;


{ Odczytanie masek ekranu i kursora. }

Procedure GetTextCursor(var arg1, arg2 : Word); assembler;
asm
   MOV  AX, 27h
   INT  33h
   LES  SI, [arg1]
   MOV  ES:[SI], AX
   LES  SI, [arg2]
   MOV  ES:[SI], BX
end;


{ Sprawdzenie widocznosci kursora myszki. }

Function IsMouseVisible : Boolean; assembler;
asm
   MOV  AX, 2Ah
   INT  33h
   AND  AL, AL
   MOV  AL, 01h
   JNS  @dalej
   XOR  AL, AL
   @dalej:
end;


{ Zakonczenie wspolpracy zmodulem MOUSE. }

Procedure MouseUnitDone;
begin
  if DataBuffer<>nil then FreeMem(DataBuffer, Size)
end;


begin
  DataBuffer:=nil
end.