unit FSimple; {$E+,N+,X+}

interface

uses UFunkcje;

type
  PNaszObiekt = ^TNaszObiekt;
  TNaszObiekt = object (TWyrazenie)
    procedure DodajElementy; virtual;
    function WynikFunkcji(nr : Word; arg : Extended) : Extended; virtual;
    function WynikOperatora(nr : Word; arg1, arg2 : Extended) : Extended; virtual;
  end;

const

  opAOdejmowanie = 100;	{ stala okreslajaca operator odejmowania; id : 100     }
  opADodawanie 	 = 101;	{ stala okreslajaca operator dodawania; id : 101       }
  opADzielenie 	 = 102;	{ stala okreslajaca operator dzielenia; id : 102       }
  opAMnozenie	 = 103;	{ stala okreslajaca operator mnozenia; id : 103        }

  fnASinus	 = 100;	{ stala okreslajaca funkcje SINUS; id : 100 	       }
  fnACosinus	 = 101;	{ stala okreslajaca funkcje COSINUS; id : 101 	       }
  fnASqrt	 = 102;	{ stala okreslajaca funkcje pierwiastkowania; id : 102 }

  stAPi		 = 100;	{ stala okreslajaca stala Pi; id : 100 		       }

implementation

Procedure TNaszObiekt.DodajElementy;
begin
  DodajOperator('-', opAOdejmowanie, 1);    { dodanie operatora -, priorytet: 1      }
  DodajOperator('+', opADodawanie, 2);	    { dodanie operatora +, priorytet: 2      }
  DodajOperator('/', opADzielenie, 3);	    { dodanie operatora /, priorytet 3	     }
  DodajOperator('*', opAMnozenie, 4);	    { dodanie operatora *, priorytet: 4      }
  DodajFunkcje('Sinus', fnASinus);	    { dodanie funkcji SINUS 		     }
  DodajFunkcje('Cosinus', fnACosinus);	    { dodanie funkcji COSINUS		     }
  DodajFunkcje('Sqr', fnASqrt);		    { dodanie funkcji pierwiastkowania	     }
  DodajStala('Pi', stAPi, Pi)		    { dodanie stalej Pi, warto: Pi=3,14... }
end;

Function TNaszObiekt.WynikFunkcji(nr : Word; arg : Extended) : Extended;
var
  w : Extended;
begin
  case nr of
    fnASinus 	: w:=Sin(arg);
    fnACosinus 	: w:=Cos(arg);
    fnASqrt	:
      if arg<0 then
        Blad(bsLiczbaUjemna, 0)
       else
        w:=Sqrt(arg)
    else w:=inherited WynikFunkcji(nr, arg)
  end;
  WynikFunkcji:=w
end;

Function TNaszObiekt.WynikOperatora(nr : Word; arg1, arg2 : Extended) : Extended;
var
  w : Extended;
begin
  case nr of
    opAOdejmowanie	: w:=arg1-arg2;
    opADodawanie 	: w:=arg1+arg2;
    opADzielenie		:
      if arg2=0 then
        Blad(bsDzieleniePrzezZero, 0)
       else
        w:=arg1/arg2;
    opAMnozenie	: w:=arg1*arg2
    else w:=inherited WynikOperatora(nr, arg1, arg2)
  end;
  WynikOperatora:=w
end;

end.