package Pytanie18_13;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;

/* Kontener zawierający grupę słów o tej samej długości */
public class WordGroup {
	private Hashtable<String, Boolean> lookup = new Hashtable<String, Boolean>();
    private ArrayList<String> group = new ArrayList<String>();
    
    public WordGroup() {

    }
    
    public boolean containsWord(String s) {
    	return lookup.containsKey(s);
    }
    
    public void addWord (String s) {
        group.add(s);
        lookup.put(s, true);
    }
    
    public int length() {
        return group.size();
    }
    
    public String getWord(int i) {
        return group.get(i);
    }
    
    public ArrayList<String> getWords(){ 
        return group;
    }
    
    public static WordGroup[] createWordGroups(String[] list) {
    	WordGroup[] groupList;
    	int maxWordLength = 0;
		// Określanie długości najdłuższego słowa
		for (int i = 0; i < list.length; i++) {
			if (list[i].length() > maxWordLength) {
				maxWordLength = list[i].length();
			}
		}

		 /* Grupowanie słów ze słownika w listy słów o tej samej długości.
		  * Lista groupList[i] zawiera listę słów o długości (i+1)
		  */
		groupList = new WordGroup[maxWordLength];
		for (int i = 0; i < list.length; i++) {
			 /* Wykonywana jest operacja wordLength - 1 (zamiast samego wordLength),
			  * ponieważ wynik jest używany jako indeks, a nie ma słów o długości 0
			  */
			int wordLength = list[i].length() - 1; 
			if (groupList[wordLength] == null) {
				groupList[wordLength] = new WordGroup();
			}
			groupList[wordLength].addWord(list[i]);
		}
		return groupList;
    }
}
