package Pytanie8_4;

/* Reprezentuje poziom parkingu */
public class Level {
	private int floor;
	private ParkingSpot[] spots;
	private int availableSpots = 0; // Liczba wolnych miejsc
	private static final int SPOTS_PER_ROW = 10;
	
	public Level(int flr, int numberSpots) {
		floor = flr;
		spots = new ParkingSpot[numberSpots];
		int largeSpots = numberSpots / 4;
		int bikeSpots = numberSpots / 4;
		int compactSpots = numberSpots - largeSpots - bikeSpots;
		for (int i = 0; i < numberSpots; i++) {
			VehicleSize sz = VehicleSize.Motorcycle;
			if (i < largeSpots) {
				sz = VehicleSize.Large;
			} else if (i < largeSpots + compactSpots) {
				sz = VehicleSize.Compact;
			}
			int row = i / SPOTS_PER_ROW;
			spots[i] = new ParkingSpot(this, row, i, sz);
		}
		availableSpots = numberSpots;
	}
	
	public int availableSpots() {
		return availableSpots;
	}
	
	/* Próba znalezienia miejsca dla danego pojazdu. Jeśli kończy się niepowodzeniem,
     * należy zwrócić false */
	public boolean parkVehicle(Vehicle vehicle) {
		if (availableSpots() < vehicle.getSpotsNeeded()) {
			return false;
		}
		int spotNumber = findAvailableSpots(vehicle);
		if (spotNumber < 0) {
			return false;
		}
		return parkStartingAtSpot(spotNumber, vehicle);
	}
	
	/* Parkowanie pojazdu od miejsca spotNumber (pojazd zajmuje vehicle.spotsNeeded miejsc) */
	private boolean parkStartingAtSpot(int spotNumber, Vehicle vehicle) {
		vehicle.clearSpots();
		boolean success = true;
		for (int i = spotNumber; i < spotNumber + vehicle.spotsNeeded; i++) {
			 success &= spots[i].park(vehicle);
		}
		availableSpots -= vehicle.spotsNeeded;
		return success;
	}
	
	/* Znajdowanie miejsca do zaparkowania pojazdu. Zwracanie indeksu miejsca lub -1 przy niepowodzeniu */
	private int findAvailableSpots(Vehicle vehicle) {
		int spotsNeeded = vehicle.getSpotsNeeded();
		int lastRow = -1;
		int spotsFound = 0;
		for (int i = 0; i < spots.length; i++) {
			ParkingSpot spot = spots[i];
			if (lastRow != spot.getRow()) {
				spotsFound = 0;
				lastRow = spot.getRow();
			}
			if (spot.canFitVehicle(vehicle)) {
				spotsFound++;
			} else {
				spotsFound = 0;
			}
			if (spotsFound == spotsNeeded) {
				return i - (spotsNeeded - 1);
			}
		}
		return -1;
	}
	
	public void print() {
		int lastRow = -1;
		for (int i = 0; i < spots.length; i++) {
			ParkingSpot spot = spots[i];
			if (spot.getRow() != lastRow) {
				System.out.print("  ");
				lastRow = spot.getRow();
			}
			spot.print();
		}
	}
	
	/* Po zwolnieniu miejsca przez pojazd należy zwiększyć wartość zmiennej availableSpots */
	public void spotFreed() {
		availableSpots++;
	}
}
