package Pytanie16_4;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.concurrent.locks.Lock;

import Pytanie16_4.LockNode.VisitState;

public class LockFactory {
	private static LockFactory instance;
	
	private int numberOfLocks = 5; /* Wartość domyślna */
	private LockNode[] locks;
	
	/* Odwzorowanie między procesem (lub właścicielem) a deklarowaną przez 
	 * ten proces kolejnością zajmowania blokad */
	private Hashtable<Integer, LinkedList<LockNode>> lockOrder;
	
	private LockFactory(int count) {
		numberOfLocks = count;
		locks = new LockNode[numberOfLocks];
		lockOrder = new Hashtable<Integer, LinkedList<LockNode>>();
		for (int i = 0; i < numberOfLocks; i++) {
			locks[i] = new LockNode(i, count);
		}
	}
	
	public static LockFactory getInstance() {
		return instance;
	}
	
	public static LockFactory initialize(int count) {
		if (instance == null) {
			instance = new LockFactory(count);
		}
		return instance;
	}
	
	public boolean hasCycle(Hashtable<Integer, Boolean> touchedNodes, int[] resourcesInOrder) {
		/* Sprawdzanie cyklu */
		for (int resource : resourcesInOrder) {
			if (touchedNodes.get(resource) == false) {
				LockNode n = locks[resource];
				if (n.hasCycle(touchedNodes)) {
					return true;
				}
			}
		}
		return false;
	}

	/* Aby uniknąć zakleszczenia, należy wymusić na procesach deklarowanie kolejności
	 * zajmowania blokad. Trzeba sprawdzić, czy dana kolejność nie prowadzi do zakleszczenia
	 * (cyklu w grafie skierowanym)
	 */
	public boolean declare(int ownerId, int[] resourcesInOrder) {
		Hashtable<Integer, Boolean> touchedNodes = new Hashtable<Integer, Boolean>();
		
		/* Dodawanie węzłów do grafu */
		int index = 1;
		touchedNodes.put(resourcesInOrder[0], false);
		for (index = 1; index < resourcesInOrder.length; index++) {
			LockNode prev = locks[resourcesInOrder[index - 1]];
			LockNode curr = locks[resourcesInOrder[index]];
			prev.joinTo(curr);
			touchedNodes.put(resourcesInOrder[index], false);
		}
		
		/* Jeśli powstał cykl, należy usunąć listę zasobów i zwrócić wartość false */
		if (hasCycle(touchedNodes, resourcesInOrder)) {
			for (int j = 1; j < resourcesInOrder.length; j++) {
				LockNode p = locks[resourcesInOrder[j - 1]];
				LockNode c = locks[resourcesInOrder[j]];
				p.remove(c);
			}
			return false;
		}
		
		/* Nie wykryto cykli. Należy zachować zadeklarowaną kolejność, aby móc zweryfikować,
		 * że proces rzeczywiście zajmuje blokady w tej kolejności */
		LinkedList<LockNode> list = new LinkedList<LockNode>();
		for (int i = 0; i < resourcesInOrder.length; i++) {
			LockNode resource = locks[resourcesInOrder[i]];
			list.add(resource);
		}
		lockOrder.put(ownerId, list);
		
		return true;
	}
	
	/* Zajmowanie blokady (po wcześniejszym sprawdzeniu, czy proces rzeczywiście
	 * zajmuje ją w zadeklarowanej kolejności) */
	public Lock getLock(int ownerId, int resourceID) {
		LinkedList<LockNode> list = lockOrder.get(ownerId);
		if (list == null) {
			return null;
		}
		
		LockNode head = list.getFirst();
		if (head.getId() == resourceID) {
			list.removeFirst();
			return head.getLock();
		}
		return null;
	}
}
