package Wprowadzenie;

import CtCILibrary.AssortedMethods;

public class MergeSort {	
	public static void mergesort(int[] array) {
		int[] helper = new int[array.length];
		mergesort(array, helper, 0, array.length - 1);
	}

	public static void mergesort(int[] array, int[] helper, int low, int high) {
		if (low < high) {
			int middle = (low + high) / 2;
			mergesort(array, helper, low, middle); // Sortowanie lewej połowy
			mergesort(array, helper, middle+1, high); // Sortowanie prawej połowy
			merge(array, helper, low, middle, high); // Scalanie połówek
		}
	}

	public static void merge(int[] array, int[] helper, int low, int middle, int high) {
		/* Kopiowanie obu połówek do tablicy pomocniczej */
		for (int i = low; i <= high; i++) {
			helper[i] = array[i];
		}

		int helperLeft = low;
		int helperRight = middle + 1;
		int current = low;

		/* Przechodzenie po tablicy pomocniczej. Porównywanie lewej i prawej
		 * połówki, kopiowanie mniejszego elementu z połówek do
		 * pierwotnej tablicy */
		while (helperLeft <= middle && helperRight <= high) {
			if (helper[helperLeft] <= helper[helperRight]) {
				array[current] = helper[helperLeft];
				helperLeft++;
			} else { // Jeśli element z prawej połówki jest mniejszy od elementu z lewej połówki
				array[current] = helper[helperRight];
				helperRight++;
			}
			current++;
		}

		/* Kopiowanie reszty lewej połówki do docelowej tablicy */
		int remaining = middle - helperLeft;
		for (int i = 0; i <= remaining; i++) {
			array[current + i] = helper[helperLeft + i];
		}
	}
	
	public static void main(String[] args) {
		int size = 20;
		int[] array = AssortedMethods.randomArray(size, 0, size - 1);
		int[] validate = new int[size];
		AssortedMethods.printIntArray(array);
		for (int i = 0; i < size; i++) {
			validate[array[i]]++;
		}
		mergesort(array);
		for (int i = 0; i < size; i++) {
			validate[array[i]]--;
		}		
		AssortedMethods.printIntArray(array);
		for (int i = 0; i < size; i++) {
			if (validate[i] != 0 || (i < (size-1) && array[i] > array[i+1])) {
				System.out.println("BŁĄD");
			}
		}
	}

}
