package Pytanie3_1;

import java.util.EmptyStackException;

public class Pytanie {
	static int stackSize = 10;
	static int [] buffer = new int [stackSize * 3];
	
	// Trzy wskaźniki służą do zapamiętywania indeksów wierzchołków
	static int [] stackPointer = {-1, -1, -1};
	public static void main(String [] args) throws Exception  {
		push(2, 4);
		System.out.println("Zobacz element z drugiego stosu: " + peek(2));
		push(0, 3);
		push(0, 7);
		push(0, 5);
		System.out.println("Zobacz element z zerowego stosu: " + peek(0));
		pop(0);
		System.out.println("Zobacz element z zerowego stosu: " + peek(0));
		pop(0);
		System.out.println("Zobacz element z zerowego stosu: " + peek(0));
	}

	static void push(int stackNum, int value) throws Exception {
		/* Sprawdzanie, czy istnieje miejsce na następny element */
		if (stackPointer[stackNum] + 1 >= stackSize) { 
			throw new FullStackException();
		}
		/* Przesuwanie wskaźnika do przodu i aktualizowanie wartości wierzchołka */		
		stackPointer[stackNum]++;
		buffer[absTopOfStack(stackNum)] = value;	
	}

	static int pop(int stackNum) throws Exception {
		if (isEmpty(stackNum)) {
			throw new EmptyStackException();
		}
		int value = buffer[absTopOfStack(stackNum)]; // Pobieranie wierzchołka
		buffer[absTopOfStack(stackNum)] = 0; // Zerowanie indeksu
		stackPointer[stackNum]--; // Przesuwanie wskaźnika do tyłu
		return value;
	}

	static int peek(int stackNum) {
		if (isEmpty(stackNum)) {
			throw new EmptyStackException();
		}		
		return buffer[absTopOfStack(stackNum)];
	}

	static boolean isEmpty(int stackNum) {
		return stackPointer[stackNum] == -1;
	}
	
	/* Zwraca indeks wierzchołka stosu stackNum w całej tablicy */
	static int absTopOfStack(int stackNum) {
		return stackNum * stackSize + stackPointer[stackNum];
	}	
}
