/* 
  =========================
  Rozgrzewka robota delta !
  =========================

  Ten kod umożliwia sprawdzenie, czy robot delta jest poprawnie
  zmontowany, zasięg ruchu jest prawidłowy, a przeguby
  wystarczająco elastyczne.
  
*/

var five = require("johnny-five"),
  temporal = require("temporal"),
  board = new five.Board();

board.on("ready", function() {
    var servo1 = five.Servo({ pin: 9, range: [0,90] }),
      servo2 = five.Servo({ pin: 10, range: [0,90] }),
      servo3 = five.Servo({ pin: 11, range: [0,90] });

    // Inicjowanie pozycji
    servo1.to(20);
    servo2.to(20);
    servo3.to(20);

    // Procedura rozgrzewki
    var repeat = function() {
      temporal.queue([
        { delay: 250, task: function() { servo1.to(60); } },
        { delay: 250, task: function() { servo2.to(60); } },
        { delay: 250, task: function() { servo3.to(60); } },
        { delay: 250, task: function() { servo1.to(20); } },
        { delay: 250, task: function() { servo2.to(20); } },
        { delay: 250, task: function() { servo3.to(20); } },
        { delay: 250, task: repeat }
      ]);
    };
    repeat();
});