import React, { FC, useEffect, useState } from "react";
import ThreadItem from "../../../models/ThreadItem";
import ThreadResponse from "./ThreadResponse";

interface ThreadResponsesBuilderProps {
  threadItems?: Array<ThreadItem>;
}

const ThreadResponsesBuilder: FC<ThreadResponsesBuilderProps> = ({
  threadItems,
}) => {
  const [responseElements, setResponseElements] = useState<
    JSX.Element | undefined
  >();

  useEffect(() => {
    if (threadItems) {
      const thResponses = threadItems.map((ti) => {
        return (
          <li key={`thr-${ti.id}`}>
            <ThreadResponse
              body={ti.body}
              userName={ti.userName}
              lastModifiedOn={ti.createdOn}
              points={ti.points}
            />
          </li>
        );
      });
      setResponseElements(<ul>{thResponses}</ul>);
    }
  }, [threadItems]);

  return (
    <div className="thread-body-container">
      <strong style={{ marginBottom: ".75em" }}>Odpowiedzi</strong>
      {responseElements}
    </div>
  );
};

export default ThreadResponsesBuilder;
