package org.coffeeshop;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;


/**
 * Implementacja zdefiniowanej przez uytkownika adnotacji @VerifyValue
 * Jest to oglny weryfikator sprawdzajcy warto wyliczenia.
 * Jeeli obiekt wyliczenia ma metod getValue(), to dokonuje walidacji na podstawie wartoci wyliczeniowej.
 * W przeciwnym przypadku uywa EnumConstant.
 *
 * @author Bhakti Mehta
 */
public class VerifyValueValidator implements ConstraintValidator<VerifyValue, Object> {

    Class<? extends Enum<?>> enumClass;

    public void initialize(final VerifyValue enumObject) {
        enumClass = enumObject.value();

    }

    /**
     * Sprawdza czy okrelona warto jest poprawna.
     * @param myval  Warto obiektu
     * @param constraintValidatorContext
     * @return
     */
    public boolean isValid(final Object myval,
                           final ConstraintValidatorContext constraintValidatorContext) {


        if ((myval != null) && (enumClass != null)) {
            Enum[] enumValues = enumClass.getEnumConstants();
            Object enumValue = null;

            for (Enum enumerable : enumValues)   {
                if (myval.equals(enumerable.toString()) ) return true;
                enumValue = getEnumValue(enumerable);
                if ((enumValue != null)
                        && (myval.toString().equals(enumValue.toString())))  {
                    return true;
                }
            }
        }
        return false;
    }


    /**
     * Wywouje metod getValue() dla wyliczenia, jeli jest.
     * @param enumerable Obiekt wyliczenia
     * @return  Zwraca warto wyliczenia z getValue() lub
     *          sta wyliczeniow.
     */
    private Object getEnumValue(Enum<?> enumerable) {
        try {
            for (Method method: enumerable.getClass().getDeclaredMethods()) {
                if (method.getName().equals("getValue")) {
                    return method.invoke(enumerable);
                }
            }
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }




}
