import {render, screen, waitFor} from "@testing-library/react";
import user from '@testing-library/user-event';
import YearCalendar from "./YearCalendar";
import timekeeper from "./timekeeper";
import App from "./App";

let renders = [];
let tracker = (
    id,
    phase,
    actualDuration,
    baseDuration,
    startTime,
    commitTime,
    interactions
) => {
    renders.push({
        id,
        phase,
        actualDuration,
        baseDuration,
        startTime,
        commitTime,
        interactions
    })
};

const t = timekeeper();

describe('Komponent AppCalendar', () => {
    beforeEach(() => {
        renders = [];
        t.next();
    });
    afterEach(() => {
        console.log('Czas wykonania: ', t.next().value);
        console.table(renders);
    });
    it('powinien zrobić co trzeba', async () => {
        render(<App onRender={tracker}/>);
        user.click(screen.getByRole('button', {name: /poprzedni/i}))
        await waitFor(async () => {
            const items = await screen.getAllByText(/rok: 2022/i);  
            return expect(items).toHaveLength(2);
        }, {timeout: 5000});
    }, 30000);
});