import Form from 'react-bootstrap/Form'
import Col from 'react-bootstrap/Col'
import Button from 'react-bootstrap/Button'
import Alert from 'react-bootstrap/Alert'
import { useState } from 'react'
import './App.css'

function App() {
  const [submitted, setSubmitted] = useState(false)

  return (
    <div className="App">
      <h1>VC Funding Registration</h1>
      <Form>
        <Form.Row>
          <Form.Group as={Col} controlId="startupName">
            <Form.Label>Nazwa start-upu</Form.Label>
            <Form.Control placeholder="Tylko żadnych nazw kończących się na... ex, proszę!"/>
          </Form.Group>
          <Form.Group as={Col} controlId="market">
            <Form.Label>Rynek</Form.Label>
            <Form.Control placeholder="np. seniorzy na TikToku" />
          </Form.Group>
          <Form.Group as={Col} controlId="appType">
            <Form.Label>Typ aplikacji</Form.Label>
            <Form.Control as="select" defaultValue="Wybierz...">
              <option>Progresywna aplikacja internetowa</option>
              <option>Klasyczna aplikacja internetowa</option>
              <option>Aplikacja na Androida</option>
              <option>Aplikacja na iOS-a</option>
              <option>Aplikacja NJ SNAP</option>
              <option>VT220</option>
            </Form.Control>
          </Form.Group>
        </Form.Row>

        <Form.Row>
          <Form.Group as={Col} controlId="description">
            <Form.Label>Opis</Form.Label>
            <Form.Control as="textarea" />
          </Form.Group>
        </Form.Row>

        <Form.Group id="technologiesUsed">
          <Form.Label>
            Zastosowane technologie (zaznacz przynajmniej 3)
          </Form.Label>
          <Form.Control as="select" multiple>
            <option>Blockchain</option>
            <option>Uczenie maszynowe</option>
            <option>Komputery kwantowe</option>
            <option>Samochody autonomiczne</option>
            <option>Pętle for</option>
          </Form.Control>
        </Form.Group>

        <Button variant="primary" onClick={() => setSubmitted(true)}>
          Wyślij
        </Button>
      </Form>
      <Alert
        show={submitted}
        variant="success"
        onClose={() => setSubmitted(false)}
        dismissible
      >
        <Alert.Heading>Będziemy w kontakcie!</Alert.Heading>
        <p>Jeden z naszych partnerów niebawem się z Wami skontaktuje.</p>
      </Alert>
    </div>
  )
}

export default App
