const { ApolloServer } = require('apollo-server')
const requireText = require('require-text')

const typeDefs = requireText('./schema.graphql', require)

const messages = [
  {
    id: 0,
    author: 'SC',
    text: 'Obrót zakończony, poziom zachowany. Operacja zakończona.',
  },
  {
    id: 1,
    author: 'PAO',
    text: 'Dobra robota, jesteście na ścieżce podejścia. Wysokość wynosi 3,5 km.',
  },
  {
    id: 2,
    author: 'CAPCOM',
    text: 'W Houston wszystko gotowe. Zostaje minuta.',
  },
]

const resolvers = {
  Query: {
    messages: () => messages,
  },
  Mutation: {
    addMessage: (parent, message) => {
      const item = { id: messages.length + 1, ...message }
      messages.push(item)
      return item
    },
  },
}

const server = new ApolloServer({
  typeDefs,
  resolvers,
})

server.listen({ port: 5000 }).then(({ url }) => {
  console.log(`🚀 Serwer dostępny pod adresem ${url}!`)
})
