import {useDispatch} from "react-redux";

import "./Boots.css";

const products = [
  {
    productId: 'BE8290004',
    name: 'Buty narciarskie',
    description: 'Mondo 26,5. Białe.',
    price: 1980.62,
    },
    {
    productId: 'PC6310098',
    name: 'Buty snowboardowe',
    description: 'Mondo 27,5. Niebieskie.',
    price: 1125.59,
    },
    {
    productId: 'RR5430103',
    name: 'Buty trekkingowe',
    description: 'Mondo 27,3. Brązowe.',
    price: 734.98,
    },
  ]
  
export default () => {
  const dispatch = useDispatch();

  return <div className='Boots'>
    <h1>Buty</h1>

    <dl className='Boots-products'>
      {
        products.map(product => <>
          <dt>{product.name}</dt>
          <dd>
            <p>{product.description}</p>
            <p>{product.price.toLocaleString("pl-PL")} zł</p>
            <button
              onClick={() => dispatch({type: 'buy', payload: product})}>
              Dodaj do koszyka
            </button>
          </dd>
        </>)
      }
    </dl>
  </div>;
};
