import reducer from './reducer'

describe('reduktor', () => {
  it('powinien zwrócić niezmienioną kopię stanu jeśli nie zna akcji', () => {
    let state = {
      basket: [
        { productId: 'fgdss', name: 'kask', quantity: 3 },
        { productId: '4322f', name: 'lina', quantity: 2 },
        { productId: '54345', name: 'kurtka', quantity: 1 },
      ],
    }
    const actual = reducer(state, { type: 'transpozycja' })
    expect(actual).toEqual({
      basket: [
        { productId: 'fgdss', name: 'kask', quantity: 3 },
        { productId: '4322f', name: 'lina', quantity: 2 },
        { productId: '54345', name: 'kurtka', quantity: 1 },
      ],
    })
  })
  it('powinien móc dodać produkt do pustego koszyka', () => {
    const actual = reducer(undefined, {
      type: 'buy',
      payload: { productId: 'abcd', name: 'raki' },
    })
    expect(actual).toEqual({
      basket: [{ productId: 'abcd', name: 'raki', quantity: 1 }],
    })
  })
  it('powinien móc dodać produkt do koszyka zawierającego inne produkty', () => {
    let state = {
      basket: [
        { productId: 'fgdss', name: 'kask', quantity: 3 },
        { productId: '4322f', name: 'lina', quantity: 2 },
        { productId: '54345', name: 'kurtka', quantity: 1 },
      ],
    }
    const actual = reducer(state, {
      type: 'buy',
      payload: { productId: 'abcd', name: 'raki' },
    })
    expect(actual).toEqual({
      basket: [
        { productId: 'fgdss', name: 'kask', quantity: 3 },
        { productId: '4322f', name: 'lina', quantity: 2 },
        { productId: '54345', name: 'kurtka', quantity: 1 },
        { productId: 'abcd', name: 'raki', quantity: 1 },
      ],
    })
  })
  it('powinien zwiększyć liczbę egzemplarzy jeśli dodajemy produkt, który już wcześniej kupiliśmy', () => {
    let state = {
      basket: [
        { productId: 'fgdss', name: 'kask', quantity: 3 },
        { productId: '4322f', name: 'lina', quantity: 2 },
        { productId: '54345', name: 'kurtka', quantity: 1 },
      ],
    }
    const actual = reducer(state, {
      type: 'buy',
      payload: { productId: '4322f', name: 'lina' },
    })
    expect(actual).toEqual({
      basket: [
        { productId: 'fgdss', name: 'kask', quantity: 3 },
        { productId: '4322f', name: 'lina', quantity: 3 },
        { productId: '54345', name: 'kurtka', quantity: 1 },
      ],
    })
  })
  it('powinien móc usunąć całą zawartość koszyka', () => {
    let state = {
      basket: [
        { productId: 'fgdss', name: 'kask', quantity: 3 },
        { productId: '4322f', name: 'lina', quantity: 2 },
        { productId: '54345', name: 'kurtka', quantity: 1 },
      ],
    }
    const actual = reducer(state, { type: 'clearBasket' })
    expect(actual).toEqual({ basket: [] })
  })
})
