import { MemoryRouter } from 'react-router'
import { Route } from 'react-router-dom'
import { fireEvent, render, screen } from '@testing-library/react'

import About from './About'

describe('Komponent About', () => {
  it('domyślnie powinien wyświetlać osoby', () => {
    render(
      <MemoryRouter initialEntries={[{ pathname: '/about' }]}>
        <Route path="/about/:tabId?">
          <About />
        </Route>
      </MemoryRouter>
    )

    expect(screen.getByText('Krystyna Słomka')).toBeInTheDocument()

    fireEvent(
      screen.getByText('Biura'),
      new MouseEvent('click', {
        bubbles: true,
        cancelable: true,
      })
    )

    expect(screen.getByText('Wrocław')).toBeInTheDocument()
  })
})
