import { useState } from 'react'

import Alert from './Alert'

export default {
  title: 'Komponent Alert',
}

export const Podstawowy = () => <Alert />

export const ZOpen = () => <Alert open />

export const ZTitle = () => <Alert title="Opuścić stronę?" open />

export const ZMessage = () => (
  <Alert
    title="Opuścić stronę?"
    message="Wprowadziłeś zmiany. Czy na pewno chcesz opuścić stronę?"
    open
  />
)

export const ZOnCancelIOnConfirm = () => {
  const [clickName, setClickName] = useState()

  return (
    <div>
      Ostatnie kliknięcie: {clickName}
      <Alert
        title="Opuścić stronę?"
        message="Wprowadziłeś zmiany. Czy na pewno chcesz opuścić stronę?"
        onOK={() => setClickName('OK')}
        onCancel={() => setClickName('Anuluj')}
        open
      />
    </div>
  )
}
