/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.common.internal.Closeables;
import com.facebook.common.memory.PooledByteBufferFactory;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener;
import com.facebook.imagepipeline.producers.StatefulProducerRunnable;
import com.facebook.imagepipeline.request.ImageRequest;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;

public abstract class LocalFetchProducer
implements Producer<EncodedImage> {
    private final Executor mExecutor;
    private final PooledByteBufferFactory mPooledByteBufferFactory;

    protected LocalFetchProducer(Executor executor, PooledByteBufferFactory pooledByteBufferFactory) {
        this.mExecutor = executor;
        this.mPooledByteBufferFactory = pooledByteBufferFactory;
    }

    @Override
    public void produceResults(Consumer<EncodedImage> consumer, ProducerContext producerContext) {
        final ProducerListener listener = producerContext.getListener();
        final String requestId = producerContext.getId();
        final ImageRequest imageRequest = producerContext.getImageRequest();
        final StatefulProducerRunnable<EncodedImage> cancellableProducerRunnable = new StatefulProducerRunnable<EncodedImage>(consumer, listener, this.getProducerName(), requestId){

            protected EncodedImage getResult() throws Exception {
                EncodedImage encodedImage = LocalFetchProducer.this.getEncodedImage(imageRequest);
                if (encodedImage == null) {
                    listener.onUltimateProducerReached(requestId, LocalFetchProducer.this.getProducerName(), false);
                    return null;
                }
                encodedImage.parseMetaData();
                listener.onUltimateProducerReached(requestId, LocalFetchProducer.this.getProducerName(), true);
                return encodedImage;
            }

            @Override
            protected void disposeResult(EncodedImage result) {
                EncodedImage.closeSafely((EncodedImage)result);
            }
        };
        producerContext.addCallbacks(new BaseProducerContextCallbacks(){

            @Override
            public void onCancellationRequested() {
                cancellableProducerRunnable.cancel();
            }
        });
        this.mExecutor.execute((Runnable)((Object)cancellableProducerRunnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EncodedImage getByteBufferBackedEncodedImage(InputStream inputStream, int length) throws IOException {
        EncodedImage encodedImage;
        CloseableReference ref = null;
        try {
            ref = length <= 0 ? CloseableReference.of((Closeable)this.mPooledByteBufferFactory.newByteBuffer(inputStream)) : CloseableReference.of((Closeable)this.mPooledByteBufferFactory.newByteBuffer(inputStream, length));
            encodedImage = new EncodedImage(ref);
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly((InputStream)inputStream);
            CloseableReference.closeSafely(ref);
            throw throwable;
        }
        Closeables.closeQuietly((InputStream)inputStream);
        CloseableReference.closeSafely((CloseableReference)ref);
        return encodedImage;
    }

    protected EncodedImage getEncodedImage(InputStream inputStream, int length) throws IOException {
        return this.getByteBufferBackedEncodedImage(inputStream, length);
    }

    protected abstract EncodedImage getEncodedImage(ImageRequest var1) throws IOException;

    protected abstract String getProducerName();
}

