import { ViewerData } from './types';

export const GET_VIEWER_QUERY = `
  query {
    viewer {
      name
      avatarUrl
    }
  }
  `;

type GetViewerResponse = {
  data: {
    viewer: ViewerData;
  };
};

export async function getViewer() {
  const response = await fetch(process.env.REACT_APP_GITHUB_URL!, {
    method: 'POST',
    body: JSON.stringify({
      query: GET_VIEWER_QUERY,
    }),
    headers: {
      'Content-Type': 'application/json',
      Authorization: `bearer ${process.env.REACT_APP_GITHUB_PAT}`,
    },
  });
  const body = (await response.json()) as unknown;
  assertIsGetViewerResponse(body);
  return body.data;
}

function assertIsGetViewerResponse(response: any): asserts response is GetViewerResponse {
  if (!('data' in response)) {
    throw new Error("Odpowiedź nie zawiera danych");
  }
  if (typeof response.data !== 'object') {
    throw new Error('Odpowiedź nie jest obiektem');
  }
  if (!('viewer' in response.data)) {
    throw new Error("Dane nie zawierają widza");
  }
  if (typeof response.data.viewer !== 'object') {
    throw new Error('Widz nie jest obiektem');
  }
  if (!('name' in response.data.viewer)) {
    throw new Error("Widz nie zawiera nazwy");
  }
  if (typeof response.data.viewer.name !== 'string') {
    throw new Error('Nazwa widza nie jest ciągiem znaków');
  }
  if (!('avatarUrl' in response.data.viewer)) {
    throw new Error("Widz nie zawiera adresu URL awatara");
  }
  if (typeof response.data.viewer.avatarUrl !== 'string') {
    throw new Error('Adres URL awatara widza nie jest ciągiem znaków');
  }
}
