import { PostData } from './types';

export async function getPosts() {
  const response = await fetch(process.env.REACT_APP_API_URL!);
  const body = (await response.json()) as unknown;
  assertIsPosts(body);
  return body;
}

export function assertIsPosts(postsData: unknown): asserts postsData is PostData[] {
  if (!Array.isArray(postsData)) {
    throw new Error("posts isn't an array");
  }
  if (postsData.length === 0) {
    return;
  }
  postsData.forEach((post) => {
    if (!('id' in post)) {
      throw new Error("post nie zawiera id");
    }
    if (typeof post.id !== 'number') {
      throw new Error('id nie jest liczbą');
    }
    if (!('title' in post)) {
      throw new Error("post nie zawiera tytułu");
    }
    if (typeof post.title !== 'string') {
      throw new Error('tytuł nie jest tekstem');
    }
    if (!('description' in post)) {
      throw new Error("post nie zawiera tytułu");
    }
    if (typeof post.description !== 'string') {
      throw new Error('opis nie jest tekstem');
    }
  });
}
