# Rozdział 1. Poznajemy Reacta

Powszechne wykorzystanie Reacta w ogromnych witrynach internetowych pokazuje, że ta technologia jest wystarczająco stabilna do stosowania na dużą skalę. React jest gotowy.

## Instalacja Node.js i menedżera pakietów NPM

Podczas pracy z frameworkami Node i React, trzeba skorzystać z powłoki. Na platformie Mac to jest narzędzie o nazwie Terminal. Z kolei na platformie Windows to jest Wierszp poleceń. Wydaj wymienione polecenia, aby sprawdzić bieżące wersje node i npm. Jeżeli zachodzi potrzeba, przeprowadź instalację lub uaktualnienie zgodnie z procedurą przedstawioną nieco dalej w pliku.

Przede wszystkim sprawdź, czy masz zainstalowane Node.js:

```
$ node -v
```

Jeżeli dane wyjściowe to numer wersji, Node.js jest zainstalowane. W przeciwnym razie musisz [zainstalować Node.js](https://nodejs.org/en/) pobierając pliki z witryny internetowe Node.js. Po pobraniu programu instalacyjnego, uruchom go, a następnie wykonuj polecenia wyświetlane na ekranie.

---

Kolejny krok to sprawdzenie wersji npm:

```
$ npm -v
```

Jeżeli korzystasz z wersji wcześniejszej niż 8, powinieneś ją uaktualnić:

### Uaktualnienie na platformie Mac

```
$ sudo npm update -g npm
```

### Uaktualnienie na platformie Windows

Upewnij się o uruchomieniu Wiersza poleceń z uprawnieniami administratora:

```
$ npm update -g npm
```

##### Opcjonalna instalacja Yarn

Yarn to menedżer pakietów utworzony przez firmę Facebook. To jest alternatywa dla npm. Nie trzeba korzystać z Yarn, choć możesz zainstalować to narzędzie jeśli chcesz:

```
$ sudo npm install -g yarn
```

Dostępne są wygodne rozwiązania pozwalające na zmienę używanej wersji Node. Nie musisz z nich korzystać, ale możesz opcjonalnie zainstalować jednego z wymienionych tutaj menedżerów:

- [Instalacja menedżera wersji Node - tylko Mac (opcjonalnie)](https://github.com/creationix/nvm)
- [Instalacja menedżera wersji Node - tylko Windows (opcjonalnie)](https://github.com/coreybutler/nvm-windows)

---

## Instalacja narzędzi React Developer Tools

Kolejnym krokiem jest instalacja React Developer Tools:

- Development Tools ([Chrome](https://chrome.google.com/webstore/detail/react-developer-tools/fmkadmapgofadopljbjfkapdkoienihi?hl=en) |
  [Firefox](https://addons.mozilla.org/en-US/firefox/addon/react-devtools/))

## Praca z plikami

To repozytorium zawiera przykłady zamieszczone w różnych serwisach, więc natychmiast możesz rozpocząć eksperymentowanie z plikami. W przypadku mniejszych przykładów umieściliśmy je w JSBins i dzięki temu przykład można uruchomić bez większych problemów. Dołączyliśmy również łącza do przykładów w CodeSandboxes oraz w innych repozytoriach, gdy przykłady są obszerniejsze.

## Zasoby Reacta

Oto kilka łączy do zasobów, oficjalnej dokumentacji Reacta oraz bibliotek, z których będziemy korzystać:

- [Dokumentacja Reacta](https://facebook.github.io/react/index.html)
- [Kod źródłowy React Source](https://github.com/facebook/react)
- [Blog Reacta](https://facebook.github.io/react/blog/)
- [React NPM](https://www.npmjs.com/package/react)
- [Dokumentacja webpack](https://webpack.js.org/)
- [Dokumentacja Jest](https://facebook.github.io/jest/)
- [Dokumentacja React Router](https://reacttraining.com/react-router/)
