# Rozdział 7. Usprawnianie komponentów za pomocą zaczepów

## Przykłady

### Zaczep `useEffect`

- Blokowanie wywołania - ([uruchom](https://codesandbox.io/s/learning-react-useeffect-1-yu7f6?file=/src/App.js));
- Niedostępny kod - ([uruchom](https://codesandbox.io/s/learning-react-useeffect-2-orpoq?file=/src/App.js));
- Zaczep `useEffect` - ([uruchom](https://codesandbox.io/s/learning-react-useeffect-3-flshw?file=/src/App.js));

### Tablica zależności

- Zbyt wiele efektów - ([uruchom](https://codesandbox.io/s/learning-react-useeffect-4-w723e?file=/src/App.js))
- Zależności efektu - ([uruchom](https://codesandbox.io/s/learning-react-useeffect-5-uqol2?file=/src/App.js))
- Dowolny klawisz, aby wygenerować - ([uruchom](https://codesandbox.io/s/learning-react-useeffect-6-eg5w4?file=/src/App.js))
- Problemy związane z tablicą zależności - ([uruchom](https://codesandbox.io/s/learning-react-useeffect-7-3xo59?file=/src/App.js))
- `useMemo` - ([uruchom](https://codesandbox.io/s/learning-react-useeffect-8-w62wg?file=/src/App.js))
- Problemy związane z zależnością funkcji - ([uruchom](https://codesandbox.io/s/learning-react-useeffect-9-yil9d?file=/src/App.js))
- `useCallback` - ([uruchom](https://codesandbox.io/s/learning-react-useeffect-10-e9im3?file=/src/App.js))

### Kiedy należy używać useLayoutEffect?

- Podstawy `useLayoutEffect` - ([uruchom](https://codesandbox.io/s/learning-react-uselayouteffect-1-bmxqw?file=/src/App.js))
- Niestandardowe użycie: `useWindowSize` - ([uruchom](https://codesandbox.io/s/learning-react-uselayouteffect-2-vuir1?file=/src/App.js))
- Niestandardowe użycie: `useMousePosition` - ([uruchom](https://codesandbox.io/s/learning-react-uselayouteffect-3-6ks6x?file=/src/App.js))

### useReducer

- Pole wyboru z użyciem `useState` - ([uruchom](https://codesandbox.io/s/learning-react-usereducer-1-ef229?file=/src/App.js))
- Pole wyboru z użyciem `toggle` - ([uruchom](https://codesandbox.io/s/learning-react-usereducer-2-oqy23?file=/src/App.js))
- Pole wyboru z użyciem `useReducer` - ([uruchom](https://codesandbox.io/s/learning-react-usereducer-3-mht63?file=/src/App.js))
- Inkrementacja za pomocą `useReducer` - ([uruchom](https://codesandbox.io/s/learning-react-usereducer-4-b1yxs?file=/src/App.js))

### useReducer i obsługa zaawansowanych informacji o stanie

- Użycie `useState` z obiektami - ([uruchom](https://codesandbox.io/s/learning-react-usereducer-complex-1-k7ibz?file=/src/App.js))
- Użycie `useReducer` z obiektami - ([uruchom](https://codesandbox.io/s/learning-react-usereducer-complex-2-ewue8?file=/src/App.js))
- Przestarzałe konstrukcje `setState` i `useReducer` - ([uruchom](https://codesandbox.io/s/learning-react-usereducer-complex-3-2wldd?file=/src/App.js))
