import {useRef, useState} from 'react';
import './Discovery.css';
import Logo from './Logo';
import Header from './Header';
import Body from './Body';
import Button from './Button';
import Rating from './Rating';
import Suggest from './Suggest';
import FormInput from './FormInput';
import Form from './Form';
import Actions from './Actions';
import Dialog from './Dialog';
import Excel from './Excel';
import DataContext from '../contexts/DataContext';

import schema from '../config/schema';

function ExcelExample() {
  const initialData = schema.name.samples.map((_, idx) => {
    const element = {};
    for (let key in schema) {
      element[key] = schema[key].samples[idx];
    }
    return element;
  });
  const [data, setData] = useState(initialData);
  function updateData(newData) {
    setData(newData);
  }
  return (
    <DataContext.Provider value={{data, updateData}}>
      <Excel />
    </DataContext.Provider>
  );
}

function DialogExample() {
  const [example, setExample] = useState(null);
  return (
    <>
      <p>
        <Button onClick={() => setExample(1)}>Przykład 1</Button>{' '}
        <Button onClick={() => setExample(2)}>Przykład 2</Button>
      </p>
      {example === 1 ? (
        <Dialog
          modal
          header="Gotowy przykład"
          onAction={(type) => {
            alert(type);
            setExample(null);
          }}>
          Witaj w oknie dialogowym!
        </Dialog>
      ) : null}

      {example === 2 ? (
        <Dialog
          header="Nie modalny, niestandardowy przycisk"
          hasCancel={false}
          confirmLabel="Whatever"
          onAction={(type) => {
            alert(type);
            setExample(null);
          }}>
          Tutaj jest miejsce na cokolwiek, np. <Button>przycisk</Button>
        </Dialog>
      ) : null}
    </>
  );
}

function Discovery() {
  const form = useRef();
  return (
    <div className="Discovery">
      <h2>Logo</h2>
      <div style={{background: '#f6f6f6', display: 'inline-block'}}>
        <Logo />
      </div>

      <h2>Header</h2>
      <DataContext.Provider value={{data: [1, 2, 3], updateData: () => {}}}>
        <Header onSearch={(e) => console.log(e)} />
      </DataContext.Provider>

      <h2>Body</h2>
      <Body>Jestem treścią wypełniającą ciało</Body>

      <h2>Przyciski</h2>
      <p>
        Przyciski z onClick:{' '}
        <Button onClick={() => alert('ouch')}>Kliknij mnie</Button>
      </p>
      <p>
        Łącze: <Button href="https://reactjs.org/">Idź za mną</Button>
      </p>
      <p>
        Nazwa klasy name:{' '}
        <Button className="Discovery-custom-button">Nic nie robię</Button>
      </p>

      <h2>Rating</h2>
      <p>
        Brak wartości początkowej: <Rating />
      </p>
      <p>
        Początkowa wartość 4: <Rating defaultValue={4} />
      </p>
      <p>
        Tutaj najwyższa wartość wynosi 11: <Rating max={11} />
      </p>
      <p>
        Tylko do odczytu: <Rating readonly={true} defaultValue={3} />
      </p>

      <h2>Suggest</h2>
      <p>
        <Suggest options={['eenie', 'meenie', 'miney', 'mo']} />
      </p>

      <h2>Elementy formularza</h2>
      <table className="Discovery-pad">
        <tbody>
          <tr>
            <td>Zwykły element formularza</td>
            <td>
              <FormInput />
            </td>
          </tr>
          <tr>
            <td>Wstępnie wypełniony</td>
            <td>
              <FormInput defaultValue="with a default" />
            </td>
          </tr>
          <tr>
            <td>Rok</td>
            <td>
              <FormInput type="year" />
            </td>
          </tr>
          <tr>
            <td>Ocena</td>
            <td>
              <FormInput type="rating" defaultValue={4} />
            </td>
          </tr>
          <tr>
            <td>Suggest</td>
            <td>
              <FormInput
                type="suggest"
                options={['czerwony', 'zielony', 'niebieski']}
                defaultValue="zielony"
              />
            </td>
          </tr>
          <tr>
            <td>Zwykły obszar tekstowy</td>
            <td>
              <FormInput type="textarea" />
            </td>
          </tr>
        </tbody>
      </table>

      <h2>Form</h2>
      <div className="Discovery-pad Discovery-narrow">
        <Form
          ref={form}
          fields={{
            rateme: {label: 'Ocena', type: 'rating'},
            freetext: {label: 'Witaj'},
          }}
          initialData={{rateme: 4, freetext: 'Cześć'}}
        />
        <p>
          <Button
            onClick={() => {
              const data = {};
              Array.from(form.current).forEach(
                (input) => (data[input.id] = input.value),
              );
              alert(JSON.stringify(data));
            }}>
            Submit
          </Button>
        </p>
      </div>

      <h3>Formularz tylko do odczytu</h3>
      <div className="Discovery-pad">
        <Form
          fields={{
            rateme: {label: 'Ocena', type: 'rating'},
            freetext: {label: 'Witaj'},
          }}
          initialData={{rateme: 4, freetext: 'Cześć'}}
          readonly
        />
      </div>

      <h2>Akcje</h2>
      <p>
        <Actions onAction={(type) => alert(type)} />
      </p>

      <h2>Dialog</h2>
      <DialogExample />

      <h2>Excel</h2>
      <ExcelExample />
    </div>
  );
}

export default Discovery;
