jest.autoMockOff();

import React from 'react';
import ReactDOM from 'react-dom';
import TestUtils from 'react-addons-test-utils';
import ShallowTestUtils from 'react-shallow-testutils';

const shallowRenderer = TestUtils.createRenderer();
const CheckboxWithLabel = require('../CheckboxWithLabel');

describe('CheckboxWithLabel', () => {

  // Render a checkbox with label in the document
  shallowRenderer.render(<CheckboxWithLabel labelOn="Wł." labelOff="Wył." />);

  let checkbox = shallowRenderer.getRenderOutput();
  const component = ShallowTestUtils.getMountedInstance(shallowRenderer);

  it('domyślnie jest niezaznaczone i ma etykietę Wył.', () => {
    const expectedChildren = [
      <input type="checkbox" checked={false} onChange={component.onChange} />,
      "Wył."
    ];
    expect(checkbox.props.children).toEqual(expectedChildren);
  });


  it('zmienia etykietą w reakcji na kliknięcie', () => {
    component.onChange();

    // Updates the render
    checkbox = shallowRenderer.getRenderOutput();

    expect(checkbox.props.children[1]).toEqual('Wł.');
  });
});
