// Zależności
import { ApolloServer, makeExecutableSchema } from 'apollo-server'

// Modele
import models from './models'

// Definicje typów i resolvery
import resolvers from './graphql/resolvers'
import typeDefs from './graphql/types'

// Konfiguracja
import { $server } from '../config'

// Schemat
const schema = makeExecutableSchema({
  typeDefs,
  resolvers
})

// Serwer Apollo Server
const apolloServer = new ApolloServer({
  schema,
  context: {
    models
  }
})

const alter = true
const force = false

models.sequelize.sync({ alter, force }).then(() => {
  apolloServer
    .listen($server.port)
    .then(({ url }) => {
      // eslint-disable-next-line no-console
      console.log(`Działa pod adresem ${url}`)
    })
})
