// Zależności
import { FC } from 'react'
import useSWR from 'swr'

// Style
import { StyledCard, StyledTypes, StyledType, StyledHeader } from './Pokemon.styled'

type Props = {
  pokemonName: string
}

const Pokemon: FC<Props> = ({ pokemonName }) => {
  const { data, error } = useSWR(`https://pokeapi.co/api/v2/pokemon/${pokemonName}`)

  // Czy pamiętasz błąd ustawiony w wypadku elementu pobierającego?
  if (error || data.error) {
    return <div />
  }

  if (!data) {
    return <div>Ładowanie...</div>
  }

  const { id, name, sprites, types } = data
  const pokemonTypes = types.map((pokemonType: any) => pokemonType.type.name)

  return (
    <StyledCard pokemonType={pokemonTypes[0]}>
      <StyledHeader>
        <h2>{name}</h2>
        <div>#{id}</div>
      </StyledHeader>
      
      <img alt={name} src={sprites.front_default} />

      <StyledTypes>
        {pokemonTypes.map((pokemonType: string) => <StyledType key={pokemonType}>{pokemonType}</StyledType>)}
      </StyledTypes>
    </StyledCard>
  )
} 

export default Pokemon
