// Zależności
import ReactDOM from 'react-dom'

// Apollo
import { ApolloProvider, ApolloClient, InMemoryCache } from '@apollo/client';

// Komponenty
import AppRoutes from './AppRoutes'

// Konfiguracja
import config from './config'

// Konfiguracja klienta Apollo Client
const client = new ApolloClient({
  uri: config.apiUrl,
  cache: new InMemoryCache()
});

ReactDOM.render(
  <ApolloProvider client={client}>
    <AppRoutes />
  </ApolloProvider>
, document.querySelector('#root'))
