require File.dirname(__FILE__) + '/../test_helper'
require 'comments_controller'

# Ponownie zgłoś błędy wychwycone przez kontroler.
class CommentsController; def rescue_action(e) raise e end; end

class CommentsControllerTest < Test::Unit::TestCase
  fixtures :comments, :posts, :blogs, :users, :specs
  
  def setup
    @controller = CommentsController.new
    @request = ActionController::TestRequest.new
    @response = ActionController::TestResponse.new
    @user = users(:valid_user)
    authorize @user
    @comment = comments(:one)
    @blog = blogs(:one)
    @post = posts(:one)
    @valid_comment = { :user_id => @user, :post_id => @post,
                       :body => "Comment Body"}
  end

  def test_new_comment
    xhr :get, :new, :blog_id => @post.blog, :post_id => @post
    assert_response :success
  end

  def test_create_comment
    old_count = Comment.count
    xhr :post, :create, :blog_id => @post.blog,
                        :post_id => @post,
                        :comment => @valid_comment
    assert_response :success
    assert_equal old_count+1, Comment.count
  end

  def test_delete_comment
    old_count = Comment.count
    xhr :delete, :destroy, :blog_id => @comment.post.blog,
                           :post_id => @comment.post,
                           :id => @comment
    assert_response :success
    assert_equal old_count-1, Comment.count
  end

  # Upewnij się, że nieautoryzowani użytkownicy nie mogą usuwać komentarzy i są przekierowywani.
  def test_unauthorized_delete_comment
    @request.session[:user_id] = 2 # Nieautoryzowany użytkownik
    xhr :delete, :destroy, :blog_id => @comment.post.blog,
                           :post_id => @comment.post,
                           :id => @comment
    assert_response :redirect
    assert_redirected_to hub_url
  end
end
