class Message < ActiveRecord::BaseWithoutTable
  column :subject, :string
  column :body,    :text
  
  HUMANIZED_ATTRIBUTES = {
    :subject => "Temat",
    :body => "Treść",
  }
  
  def self.human_attribute_name(attr)
    HUMANIZED_ATTRIBUTES[attr.to_sym] || super
  end

  validates_presence_of :subject, :body, :message => "musi zawierać jakieś znaki."
  validates_length_of   :subject, :maximum => DB_STRING_MAX_LENGTH, :message => "jest zbyt długi."
  validates_length_of   :body,    :maximum => DB_TEXT_MAX_LENGTH, :message => "jest zbyt długa."
end 