# Methods added to this helper will be available to all templates in the application.
module ApplicationHelper
require 'string'
require 'object'
  def error_messages_for(*params)
    options = params.extract_options!.symbolize_keys
    if object = options.delete(:object)
      objects = [object].flatten
    else
      objects = params.collect {|object_name| instance_variable_get("@#{object_name}") }.compact
    end
    
    count   = objects.inject(0) {|sum, object| sum + object.errors.count }
    unless count.zero?
      html = {}
      [:id, :class].each do |key|
        if options.include?(key)
          value = options[key]
          html[key] = value unless value.blank?
        else
          html[key] = 'errorExplanation'
        end
      end
      
      options[:object_name] ||= params.first
      options[:header_message] = "#{count == 1 ? count.to_s + " błąd uniemożliwił" : count < 5 ? count.to_s + " błędy uniemożliwiły" : count.to_s + " błędów uniemożliwiło"}
                                       zapisanie #{options[:object_name].to_s.gsub('_', ' ')} " unless options.include?(:header_message)
      options[:message] ||= 'Problemy wystąpiły w następujących polach:' unless options.include?(:message)
      error_messages = objects.map {|object| object.errors.full_messages.map {|msg| content_tag(:li, msg) } }
      contents = ''
      contents << content_tag(options[:header_tag] || :h2, options[:header_message]) unless options[:header_message].blank?
      contents << content_tag(:p, options[:message]) unless options[:message].blank?
      contents << content_tag(:ul, error_messages)
      content_tag(:div, contents, html)
    else
      ''
    end
  end
  
  # Zwraca odnośnik do wykorzystania w układzie nawigacji.
  def nav_link(text, controller, action="index")
    link_to_unless_current text, :id => nil,
                                 :action => action,
                                 :controller => controller 
  end

  
  # Zwraca true, jeżeli użytkownika jest zalogowany, w przeciwnym razie zwraca false.
  def logged_in?
    not session[:user_id].nil?
  end
  
  def text_field_for(form, field, model, 
      size=HTML_TEXT_FIELD_SIZE,
      maxlength=DB_STRING_MAX_LENGTH)
      label = content_tag("label", "#{model.human_attribute_name(field.to_str)}:", :for => field)
      form_field = form.text_field field, :size => size, :maxlength => maxlength
      content_tag("div", "#{label} #{form_field}", :class => "form_row")
  end
  
  # Zwraca true, jeżeli wyniki powinny byc podzielone na strony
  def paginated?
    @pages and @pages.length > 1
  end


end
